/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.type;

import java.awt.Dimension;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeAsValueHandler;

public final class DimensionAsValueHandler
implements ITypeAsValueHandler<Dimension> {
    private static final String DIMENSION_VALUE_REGEX = "^[0-9]+x{1}[0-9]+$";
    private static final DimensionAsValueHandler SINGLETON = new DimensionAsValueHandler();

    public static DimensionAsValueHandler getInstance() {
        return SINGLETON;
    }

    public String getInputValueSample() {
        return "800x600";
    }

    public Dimension getValue(BuildProcess process, Node node, String key, Object inputValue) throws BuildException {
        String dimensionValue = (String)inputValue;
        if (dimensionValue.matches(DIMENSION_VALUE_REGEX)) {
            String[] widthHeight = dimensionValue.split("x");
            return new Dimension(Integer.valueOf(widthHeight[0]), Integer.valueOf(widthHeight[1]));
        }
        throw new BuildException("\"{0}\" is not a valid dimension", new Object[]{dimensionValue});
    }

    public String getRegex() {
        return DIMENSION_VALUE_REGEX;
    }

    public Class<?> getApplicableClass() {
        return Dimension.class;
    }
}

