/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.IApplicable;
import org.javabuilders.IKeyValueConsumer;
import org.javabuilders.Node;
import org.javabuilders.handler.IPropertyHandler;
import org.javabuilders.handler.ITypeAsValueHandler;
import org.javabuilders.handler.ITypeHandler;
import org.javabuilders.handler.ITypeHandlerAfterCreationProcessor;
import org.javabuilders.handler.ITypeHandlerFinishProcessor;
import org.javabuilders.layout.DefaultResize;
import org.javabuilders.util.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefinition
implements IKeyValueConsumer,
IApplicable {
    public static final Integer DEFAULT_DELAY_WEIGHT = 1000;
    public static final Logger logger = LoggerFactory.getLogger(TypeDefinition.class);
    private Class<?> applicableClass = null;
    private Set<String> requiredKeys = new HashSet<String>();
    private Set<Class<?>> requiredTypes = new HashSet();
    private Map<Class<?>, Integer> delayedTypes = new HashMap();
    private Map<String, Integer> delayedProperties = new HashMap<String, Integer>();
    private Set<String> localizedProperties = new HashSet<String>();
    private Set<Class<?>> allowedParents = new HashSet();
    private Map<String, Object> defaults = new HashMap<String, Object>();
    private Set<String> ignoredProperties = new HashSet<String>();
    private DefaultResize defaultResize = DefaultResize.NONE;
    private Map<Class<?>, Method> typesAsMethods = new HashMap();
    private ITypeHandlerFinishProcessor finishProcessor;
    private ITypeHandlerAfterCreationProcessor afterCreationProcessor;
    private ITypeAsValueHandler<? extends Object> typeAsValueHandler;
    private ITypeHandler typeHandler;
    private Map<String, String> propertyAliases = new HashMap<String, String>();
    private Map<String, Map<String, ? extends Object>> mappedProperties = new HashMap<String, Map<String, ? extends Object>>();
    private Map<String, Object> customProperties = new HashMap<String, Object>();
    private List<String> propertiesAsList = new ArrayList<String>();
    private Map<String, Class<?>> propertyConstants = new HashMap();
    private Map<String, IPropertyHandler> propertyHandlers = new HashMap<String, IPropertyHandler>();
    private Map<Class<?>, int[]> childrenCardinality = new HashMap();
    private boolean childrenCardinalityOverride = false;

    public static Integer getDelayedWeight(ITypeHandler handler, Collection<TypeDefinition> typeDefinitions) {
        Integer delayedWeight = 0;
        block0: for (TypeDefinition def : typeDefinitions) {
            Map<Class<?>, Integer> delayedClasses = def.getDelayedTypes();
            for (Class<?> delayedClass : delayedClasses.keySet()) {
                if (!delayedClass.isAssignableFrom(handler.getApplicableClass())) continue;
                delayedWeight = delayedClasses.get(delayedClass);
                break block0;
            }
        }
        return delayedWeight;
    }

    public static Integer getDelayedWeight(ITypeHandler handler, String property, Collection<TypeDefinition> typeDefinitions) {
        Integer delayedWeight = 0;
        for (TypeDefinition def : typeDefinitions) {
            Map<String, Integer> delayedProperties = def.getDelayedProperties();
            if (!delayedProperties.containsKey(property)) continue;
            delayedWeight = delayedProperties.get(property);
            break;
        }
        return delayedWeight;
    }

    public static boolean isLocalizableProperty(String propertyName, Collection<TypeDefinition> typeDefinitions) {
        boolean isLocalizable = false;
        for (TypeDefinition def : typeDefinitions) {
            if (!def.isLocalized(propertyName)) continue;
            isLocalizable = true;
            break;
        }
        return isLocalizable;
    }

    public static boolean isParentAllowed(Object parent, Collection<TypeDefinition> typeDefinitions) {
        boolean isAllowed = true;
        for (TypeDefinition def : typeDefinitions) {
            if (!def.isParentAllowed(parent)) continue;
            isAllowed = true;
            break;
        }
        return isAllowed;
    }

    public static Set<Class<?>> getAllowedParents(BuilderConfig config, Class<?> classType) {
        HashSet allowed = new HashSet();
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            for (Class<?> parentClass : def.getAllowedParents()) {
                allowed.add(parentClass);
            }
        }
        return allowed;
    }

    public static Set<String> getRequiredKeys(BuilderConfig config, Class<?> classType) {
        HashSet<String> keys = new HashSet<String>();
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            keys.addAll(def.getRequiredKeys());
        }
        return keys;
    }

    public static Set<Class<?>> getRequiredTypes(BuilderConfig config, Class<?> classType) {
        HashSet keys = new HashSet();
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            keys.addAll(def.getRequiredTypes());
        }
        return keys;
    }

    public static Map<String, Object> getDefaults(BuilderConfig config, Class<?> classType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            map.putAll(def.getDefaults());
        }
        return map;
    }

    public static Set<String> getIgnored(BuilderConfig config, Class<?> classType) {
        HashSet<String> ignored = new HashSet<String>();
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            ignored.addAll(def.getAllIgnored());
        }
        return ignored;
    }

    public static DefaultResize getDefaultResize(BuilderConfig config, Class<?> classType) {
        DefaultResize resize;
        block0: {
            resize = DefaultResize.NONE;
            Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
            Iterator<TypeDefinition> i$ = defs.iterator();
            if (!i$.hasNext()) break block0;
            TypeDefinition def = i$.next();
            resize = def.getDefaultResize();
        }
        return resize;
    }

    public static Method getTypeAsMethod(BuilderConfig config, Class<?> parentClassType, Class<?> classType) {
        Method target = null;
        Set<TypeDefinition> defs = config.getTypeDefinitions(parentClassType);
        block0: for (TypeDefinition def : defs) {
            Set<Class<?>> keySet = def.getTypesAsMethods().keySet();
            for (Class<?> mappedType : keySet) {
                if (!mappedType.isAssignableFrom(classType)) continue;
                target = def.getTypesAsMethods().get(mappedType);
                break block0;
            }
        }
        return target;
    }

    public static List<ITypeHandlerFinishProcessor> getFinishProcessors(BuilderConfig config, Class<?> classType) {
        LinkedList<ITypeHandlerFinishProcessor> list = new LinkedList<ITypeHandlerFinishProcessor>();
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            if (def.getFinishProcessor() == null) continue;
            list.add(def.getFinishProcessor());
        }
        return list;
    }

    public static List<ITypeHandlerAfterCreationProcessor> getAfterCreationProcessors(BuilderConfig config, Class<?> classType) {
        LinkedList<ITypeHandlerAfterCreationProcessor> list = new LinkedList<ITypeHandlerAfterCreationProcessor>();
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            if (def.getAfterCreationProcessor() == null) continue;
            list.add(def.getAfterCreationProcessor());
        }
        return list;
    }

    public static ITypeHandler getTypeHandler(BuilderConfig config, Class<?> classType) {
        if (classType == null) {
            throw new NullPointerException("classType cannot be null");
        }
        ITypeHandler handler = BuilderConfig.defaultTypeHandler;
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            if (def.getTypeHandler() == null) continue;
            ITypeHandler defHandler = def.getTypeHandler();
            if (defHandler.isApplicableToSubclasses()) {
                handler = defHandler;
                break;
            }
            if (!classType.equals(def.getApplicableClass())) break;
            handler = defHandler;
            break;
        }
        return handler;
    }

    public static IPropertyHandler getPropertyHandler(BuilderConfig config, Class<?> classType, String property) {
        if (classType == null) {
            throw new NullPointerException("classType cannot be null");
        }
        if (property == null) {
            throw new NullPointerException("property cannot be null");
        }
        IPropertyHandler handler = BuilderConfig.defaultPropertyHandler;
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            if (def.getPropertyHandler(property) == null) continue;
            handler = def.getPropertyHandler(property);
            break;
        }
        return handler;
    }

    public static ITypeAsValueHandler<? extends Object> getTypeAsValueHandler(BuilderConfig config, Class<?> classType) {
        TypeDefinition def;
        ITypeAsValueHandler<? extends Object> handler = null;
        if (classType.isEnum() && ((def = config.getTypeDefinition(classType)) == null || def.getTypeAsValueHandler() == null)) {
            config.forType(classType).valueHandler(TypeDefinition.createEnumTypeAsValueHandler(classType));
            if (logger.isInfoEnabled()) {
                logger.info("Created ITypeAsValueHandler instance for {}", (Object)classType.getName());
            }
        }
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def2 : defs) {
            if (def2.getTypeAsValueHandler() == null) continue;
            handler = def2.getTypeAsValueHandler();
            break;
        }
        return handler;
    }

    public static ITypeAsValueHandler<? extends Object> createEnumTypeAsValueHandler(final Class<?> enumClass) {
        ITypeAsValueHandler<Object> handler = null;
        if (enumClass.isEnum()) {
            ?[] constants = enumClass.getEnumConstants();
            final HashMap values = new HashMap();
            StringBuilder regexBuilder = new StringBuilder();
            for (Object constant : constants) {
                values.put(constant.toString(), constant);
                String shortConstant = TypeDefinition.getShortEnumConstant(constant);
                values.put(shortConstant, constant);
                if (regexBuilder.length() > 0) {
                    regexBuilder.append("|");
                }
                regexBuilder.append(constant).append("|").append(shortConstant);
            }
            final String regex = regexBuilder.toString();
            handler = new ITypeAsValueHandler<Object>(){

                @Override
                public String getInputValueSample() {
                    return values.toString();
                }

                @Override
                public String getRegex() {
                    return regex;
                }

                @Override
                public Object getValue(BuildProcess process, Node node, String key, Object inputValue) throws BuildException {
                    return values.get(inputValue);
                }

                @Override
                public Class<?> getApplicableClass() {
                    return enumClass;
                }
            };
        }
        return handler;
    }

    public static String getShortEnumConstant(Object constant) {
        String sConstant = constant.toString();
        StringBuilder builder = new StringBuilder(sConstant.length());
        if (sConstant.equals(sConstant.toUpperCase())) {
            String[] parts = sConstant.split("_");
            for (int p = 0; p < parts.length; ++p) {
                String part = parts[p];
                if (p == 0) {
                    builder.append(part.toLowerCase());
                    continue;
                }
                if (part.length() <= 0) continue;
                builder.append(part.substring(0, 1).toUpperCase());
                if (part.length() <= 1) continue;
                builder.append(part.substring(1).toLowerCase());
            }
        } else {
            builder.append(sConstant.substring(0, 1).toLowerCase());
            builder.append(sConstant.substring(1));
        }
        return builder.toString();
    }

    public static Object getPropertyValue(BuilderConfig config, Class<?> classType, String propertyName, Object value) throws BuildException {
        Object returnValue = value;
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            Map<String, ? extends Object> mappedValues = def.getMappedPropertyValues(propertyName);
            if (mappedValues == null) continue;
            if (mappedValues.containsKey(value)) {
                returnValue = mappedValues.get(value);
                break;
            }
            throw new BuildException("Invalid value \"{0}\"  for {1}.{2}. Allowed values are: {3}", value, classType.getSimpleName(), propertyName, mappedValues.keySet());
        }
        return returnValue;
    }

    public static String getPropertyForAlias(BuilderConfig config, Class<?> classType, String alias) {
        TypeDefinition def;
        String actual = null;
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        Iterator<TypeDefinition> i$ = defs.iterator();
        while (i$.hasNext() && (actual = (def = i$.next()).getPropertyForAlias(alias)) == null) {
        }
        return actual;
    }

    public static Object getCustomProperty(BuilderConfig config, Class<?> classType, String propertyName) {
        Object value = null;
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            if (!def.getCustomProperties().containsKey(propertyName)) continue;
            value = def.getCustomProperties().get(propertyName);
            break;
        }
        return value;
    }

    public static Object isList(BuilderConfig config, Class<?> classType, String propertyName) {
        boolean list = false;
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            if (!def.isList(propertyName)) continue;
            list = true;
            break;
        }
        return list;
    }

    public static Class<?> getPropertyConstantsClass(BuilderConfig config, Class<?> classType, String propertyName) {
        TypeDefinition def;
        Class<?> constants = null;
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        Iterator<TypeDefinition> i$ = defs.iterator();
        while (i$.hasNext() && (constants = (def = i$.next()).getPropertyConstants(propertyName)) == null) {
        }
        return constants;
    }

    public static Map<Class<?>, int[]> getChildrenCardinality(BuilderConfig config, Class<?> classType) {
        Map<Class<?>, int[]> children = new HashMap();
        Set<TypeDefinition> defs = config.getTypeDefinitions(classType);
        for (TypeDefinition def : defs) {
            Map<Class<?>, int[]> current = def.getChildrenCardinality();
            boolean override = def.isChildrenCardinalityOverriden();
            if (override) {
                if (current.size() <= 0) continue;
                children = current;
                break;
            }
            for (Class<?> type : current.keySet()) {
                if (children.containsKey(type)) continue;
                children.put(type, current.get(type));
            }
        }
        return children;
    }

    public TypeDefinition(Class<?> applicableClass) {
        if (applicableClass == null) {
            throw new NullPointerException("applicableClass cannot be null");
        }
        this.applicableClass = applicableClass;
    }

    @Override
    public Class<?> getApplicableClass() {
        return this.applicableClass;
    }

    public Set<Class<?>> getRequiredTypes(List<TypeDefinition> defs) {
        HashSet types = new HashSet();
        for (TypeDefinition def : defs) {
            types.addAll(def.requiredTypes);
        }
        return types;
    }

    public Set<String> getRequiredKeys() {
        return this.requiredKeys;
    }

    public Set<Class<?>> getRequiredTypes() {
        return this.requiredTypes;
    }

    public TypeDefinition requires(String ... keys) {
        for (String key : keys) {
            this.getRequiredKeys().add(key);
        }
        return this;
    }

    public TypeDefinition requires(Class<?> ... types) {
        for (Class<?> type : types) {
            this.getRequiredTypes().add(type);
        }
        return this;
    }

    public TypeDefinition delay(int delayWeight, Class<?> ... types) {
        for (Class<?> type : types) {
            this.getDelayedTypes().put(type, delayWeight);
        }
        return this;
    }

    public TypeDefinition delay(Class<?> ... types) {
        return this.delay((int)DEFAULT_DELAY_WEIGHT, types);
    }

    public TypeDefinition delay(int delayWeight, String ... properties) {
        for (String property : properties) {
            this.getDelayedProperties().put(property, delayWeight);
        }
        return this;
    }

    public TypeDefinition delay(String ... properties) {
        return this.delay((int)DEFAULT_DELAY_WEIGHT, properties);
    }

    public Map<Class<?>, Integer> getDelayedTypes() {
        return this.delayedTypes;
    }

    public Map<String, Integer> getDelayedProperties() {
        return this.delayedProperties;
    }

    @Override
    public Set<String> getConsumedKeys() {
        return this.requiredKeys;
    }

    public TypeDefinition localize(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.localize(propertyName);
        }
        return this;
    }

    public TypeDefinition localize(String propertyName) {
        this.localizedProperties.add(propertyName);
        return this;
    }

    public boolean isLocalized(String propertyName) {
        return this.localizedProperties.contains(propertyName);
    }

    public TypeDefinition ignore(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.ignore(propertyName);
        }
        return this;
    }

    public TypeDefinition ignore(String propertyName) {
        this.ignoredProperties.add(propertyName);
        return this;
    }

    public boolean isIgnored(String propertyName) {
        return this.ignoredProperties.contains(propertyName);
    }

    public Set<String> getAllIgnored() {
        return this.ignoredProperties;
    }

    public TypeDefinition allowParent(Class<?> ... parentTypes) {
        for (Class<?> parentType : parentTypes) {
            if (parentType == null) {
                throw new NullPointerException("parentType cannot be null");
            }
            this.allowedParents.add(parentType);
        }
        return this;
    }

    public Set<Class<?>> getAllowedParents() {
        return this.allowedParents;
    }

    public boolean isParentAllowed(Object parent) {
        if (parent == null) {
            throw new NullPointerException("parent cannot be null");
        }
        boolean allowed = false;
        for (Class<?> classType : this.allowedParents) {
            if (!classType.isAssignableFrom(parent.getClass())) continue;
            allowed = true;
            break;
        }
        return allowed;
    }

    public TypeDefinition defaultValue(String property, Object value) {
        if (property == null) {
            throw new NullPointerException("property cannot be null");
        }
        if (value == null) {
            this.defaults.remove(property);
        } else {
            this.defaults.put(property, value);
        }
        return this;
    }

    public TypeDefinition defaultResize(DefaultResize resize) {
        this.defaultResize = resize;
        return this;
    }

    public DefaultResize getDefaultResize() {
        return this.defaultResize;
    }

    public Map<String, Object> getDefaults() {
        return this.defaults;
    }

    public TypeDefinition typeAsMethod(Class<?> type, String methodName) {
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(this.getApplicableClass().getMethods()));
        methods.addAll(Arrays.asList(this.getApplicableClass().getDeclaredMethods()));
        Method target = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(type)) continue;
            target = method;
            break;
        }
        return this.typeAsMethod(type, target);
    }

    public TypeDefinition typeAsMethod(Class<?> type, Method method) {
        BuilderUtils.validateNotNullAndNotEmpty("method", method);
        method.setAccessible(true);
        this.typesAsMethods.put(type, method);
        return this;
    }

    public Map<Class<?>, Method> getTypesAsMethods() {
        return this.typesAsMethods;
    }

    public Map<String, ? extends Object> getMappedPropertyValues(String propertyName) {
        return this.mappedProperties.get(propertyName);
    }

    public TypeDefinition asMapped(String propertyName, Map<String, ? extends Object> values) {
        this.mappedProperties.put(propertyName, values);
        return this;
    }

    public String toString() {
        return this.applicableClass.getName();
    }

    public int hashCode() {
        return this.applicableClass.hashCode();
    }

    public ITypeHandlerFinishProcessor getFinishProcessor() {
        return this.finishProcessor;
    }

    public TypeDefinition finishProcessor(ITypeHandlerFinishProcessor finishProcessor) {
        this.finishProcessor = finishProcessor;
        return this;
    }

    public ITypeHandlerAfterCreationProcessor getAfterCreationProcessor() {
        return this.afterCreationProcessor;
    }

    public TypeDefinition afterCreationProcessor(ITypeHandlerAfterCreationProcessor processor) {
        this.afterCreationProcessor = processor;
        return this;
    }

    public TypeDefinition typeHandler(ITypeHandler typeHandler) {
        if (typeHandler == null) {
            throw new NullPointerException("typeHandler cannot be null");
        }
        if (typeHandler.getApplicableClass() == null) {
            throw new NullPointerException("ITypeHandler.getApplicableClass() cannot be null");
        }
        if (this.applicableClass.isAssignableFrom(typeHandler.getApplicableClass())) {
            this.typeHandler = typeHandler;
            return this;
        }
        throw new BuildException("Type handler {0} is not valid to handle type {1}", typeHandler, this.applicableClass);
    }

    public ITypeHandler getTypeHandler() {
        return this.typeHandler;
    }

    public ITypeAsValueHandler<? extends Object> getTypeAsValueHandler() {
        return this.typeAsValueHandler;
    }

    public TypeDefinition valueHandler(ITypeAsValueHandler<? extends Object> typeAsValueHandler) {
        this.typeAsValueHandler = typeAsValueHandler;
        return this;
    }

    public TypeDefinition propertyAlias(String propertyName, String alias) {
        this.propertyAliases.put(alias, propertyName);
        return this;
    }

    public String getPropertyForAlias(String alias) {
        return this.propertyAliases.get(alias);
    }

    public TypeDefinition customProperty(String propertyName, Object value) {
        this.getCustomProperties().put(propertyName, value);
        return this;
    }

    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public TypeDefinition asList(String ... propertyNames) {
        for (String propertyName : propertyNames) {
            this.propertiesAsList.add(propertyName);
        }
        return this;
    }

    public boolean isList(String propertyName) {
        return this.propertiesAsList.contains(propertyName);
    }

    public TypeDefinition propertyConstants(String propertyName, Class<?> constantsClass) {
        this.propertyConstants.put(propertyName, constantsClass);
        return this;
    }

    public Class<?> getPropertyConstants(String propertyName) {
        return this.propertyConstants.get(propertyName);
    }

    public TypeDefinition propertyHandler(IPropertyHandler ... handlers) {
        for (IPropertyHandler handler : handlers) {
            if (handler == null) {
                throw new NullPointerException("handler cannot be null");
            }
            for (String key : handler.getConsumedKeys()) {
                this.propertyHandlers.put(key, handler);
            }
        }
        return this;
    }

    public IPropertyHandler getPropertyHandler(String property) {
        return this.propertyHandlers.get(property);
    }

    public TypeDefinition childrenOverride(boolean override) {
        this.childrenCardinalityOverride = override;
        return this;
    }

    public TypeDefinition children(Class<?> type, int min, int max) {
        int[] cardinality = new int[]{min, max};
        this.childrenCardinality.put(type, cardinality);
        return this;
    }

    public TypeDefinition children(Class<?> type, int exact) {
        return this.children(type, exact, exact);
    }

    public TypeDefinition children(int min, int max) {
        return this.children(Object.class, min, max);
    }

    public TypeDefinition children(int exact) {
        return this.children(Object.class, exact, exact);
    }

    public Map<Class<?>, int[]> getChildrenCardinality() {
        return this.childrenCardinality;
    }

    public boolean isChildrenCardinalityOverriden() {
        return this.childrenCardinalityOverride;
    }
}

