/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.javabuilders.ValueListDefinition;

public class Values<K, V>
extends LinkedHashMap<K, V> {
    private Map<Object, String> errorMessages = new HashMap<Object, String>();
    private ValueListDefinition definition = null;

    public Values() {
        this((ValueListDefinition)null);
    }

    public Values(ValueListDefinition def) {
        this.definition = def;
    }

    public void put(K key, V value, String errorMessageFormat, Object ... messageArgs) {
        this.put(key, value);
        this.errorMessages.put(key, String.format(errorMessageFormat, messageArgs));
    }

    public boolean isValid(String key) {
        return this.errorMessages.containsKey(key);
    }

    public boolean isValid() {
        return this.errorMessages.size() == 0;
    }

    public String getErrors() {
        StringBuilder builder = new StringBuilder();
        for (String msg : this.errorMessages.values()) {
            builder.append(msg);
            builder.append("\n");
        }
        return builder.toString();
    }

    public String getError(String key) {
        return this.errorMessages.get(key);
    }

    public ValueListDefinition getDefinition() {
        return this.definition;
    }
}

