/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.type;

import java.util.List;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.Node;
import org.javabuilders.handler.ITypeAsValueHandler;

public class IntegerArrayAsValueHandler
implements ITypeAsValueHandler<Integer[]> {
    private static final IntegerArrayAsValueHandler singleton = new IntegerArrayAsValueHandler();
    public static final String REGEX_MATCHER = "\\[\\s*(([0-9]+\\s*)|([0-9]+\\s*,\\s*[0-9]+\\s*)+)\\s*\\]";

    public static IntegerArrayAsValueHandler getInstance() {
        return singleton;
    }

    private IntegerArrayAsValueHandler() {
    }

    @Override
    public String getInputValueSample() {
        return "weights=(30,40,30)";
    }

    @Override
    public String getRegex() {
        return REGEX_MATCHER;
    }

    @Override
    public Integer[] getValue(BuildProcess process, Node node, String key, Object inputValue) throws BuildException {
        List values = (List)inputValue;
        Integer[] returnValue = new Integer[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            returnValue[i] = ((Long)values.get(i)).intValue();
        }
        return returnValue;
    }

    public Class<Integer[]> getApplicableClass() {
        return Integer[].class;
    }
}

