/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javabuilders.BuildException;

public class Node {
    private Object mainObject = null;
    private Node parent = null;
    private String key = null;
    private Map<String, List<Object>> childValues = new HashMap<String, List<Object>>();
    private Set<Node> childNodes = new LinkedHashSet<Node>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Set<String> consumedKeys = new HashSet<String>();
    private boolean usePreInstantiatedRoot = false;
    private Map<String, Object> customProperties = new HashMap<String, Object>();

    Node(Node parent, String key) {
        this(parent, key, null);
    }

    public Node(String key, Map<String, Object> properties) {
        this(null, key, properties);
    }

    public Node(Node parent, String key, Map<String, Object> properties) {
        this(parent, key, properties, null);
    }

    public Node(Node parent, String key, Map<String, Object> properties, Object mainObject) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        this.key = key;
        if (properties != null) {
            this.properties = properties;
        }
        if (parent != null) {
            parent.addChildNode(this);
            this.parent = parent;
        }
        if (mainObject != null) {
            this.setMainObject(mainObject);
        }
    }

    public Object getMainObject() {
        return this.mainObject;
    }

    public void setMainObject(Object object) {
        this.mainObject = object;
    }

    public Node getParent() {
        return this.parent;
    }

    public Object getParentObject(Class<?> ... parentTypes) {
        Node parentNode = null;
        Class<?> type = this.getMainObject().getClass();
        Node currentNode = this;
        block0: while (type != null) {
            for (Class<?> parentType : parentTypes) {
                if (!parentType.isAssignableFrom(type)) continue;
                parentNode = currentNode;
                break block0;
            }
            if ((currentNode = currentNode.getParent()) != null) {
                type = currentNode.getMainObject().getClass();
                continue;
            }
            type = null;
        }
        if (parentNode != null) {
            return parentNode.getMainObject();
        }
        return null;
    }

    public Map<String, List<Object>> getChildValues() {
        return this.childValues;
    }

    public List<Object> getChildValues(String key) {
        return this.childValues.get(key);
    }

    public Object getFirstChildValue(String key) {
        return this.childValues.get(key).get(0);
    }

    public void addChildValue(String key, Object value) {
        List<Object> list = this.childValues.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            this.childValues.put(key, list);
        }
        list.add(value);
    }

    public Set<Node> getChildNodes() {
        return this.childNodes;
    }

    public Set<Node> getChildNodes(Class<?> ... classFilter) {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>();
        for (Node child : this.getChildNodes()) {
            for (Class<?> type : classFilter) {
                if (!type.isAssignableFrom(child.getMainObject().getClass())) continue;
                nodes.add(child);
            }
        }
        return nodes;
    }

    public Node getContentNode() {
        return this.getChildNode("content");
    }

    public Set<Node> getContentNodes() {
        Node content = this.getContentNode();
        if (content != null) {
            return content.getChildNodes();
        }
        return null;
    }

    public Set<Node> getContentNodes(Class<?> ... classFilter) {
        Node content = this.getContentNode();
        if (content != null) {
            return content.getChildNodes(classFilter);
        }
        return new HashSet<Node>();
    }

    public <C> Set<C> getContentObjects(Class<? extends C> classFilter) {
        Set<Node> contents = this.getContentNodes(classFilter);
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
        for (Node node : contents) {
            objects.add(node.getMainObject());
        }
        return objects;
    }

    public <C> Set<C> getChildObjects(Class<? extends C> classFilter) {
        Set<Node> contents = this.getChildNodes(classFilter);
        LinkedHashSet<Object> objects = new LinkedHashSet<Object>();
        for (Node node : contents) {
            objects.add(node.getMainObject());
        }
        return objects;
    }

    public <C> Set<C> getSiblingObjects(Class<? extends C> classFilter) {
        return this.getParent().getChildObjects(classFilter);
    }

    public <C> List<Map<String, Object>> getContentData(Class<? extends C> classFilter) {
        LinkedList<Map<String, Object>> data = new LinkedList<Map<String, Object>>();
        String name = classFilter.getSimpleName();
        Object ct = this.getProperty("content");
        if (ct instanceof List) {
            List list = (List)ct;
            for (Object entry : list) {
                if (!(entry instanceof Map)) continue;
                Map row = (Map)entry;
                for (String key : row.keySet()) {
                    if (!name.equals(key)) continue;
                    data.add((Map<String, Object>)row.get(key));
                }
            }
        }
        return data;
    }

    public Node getChildNode(String key) {
        for (Node node : this.childNodes) {
            if (!node.getKey().equals(key)) continue;
            return node;
        }
        return null;
    }

    public void addChildNode(Node node) {
        this.childNodes.add(node);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean containsProperty(String key) {
        return this.getProperties().containsKey(key);
    }

    public String getStringProperty(String ... propertyAliases) throws BuildException {
        String value = null;
        for (String alias : propertyAliases) {
            if (!this.getProperties().containsKey(alias)) continue;
            if (value == null) {
                Object temp = this.getProperties().get(alias);
                value = temp instanceof String ? (String)temp : String.valueOf(temp);
                continue;
            }
            throw new BuildException("Found multiple alias values for the same property: " + propertyAliases, new Object[0]);
        }
        return value;
    }

    public Long getLongProperty(String ... propertyAliases) throws BuildException {
        Long value = null;
        for (String alias : propertyAliases) {
            if (!this.getProperties().containsKey(alias)) continue;
            if (value == null) {
                value = (Long)this.getProperties().get(alias);
                continue;
            }
            throw new BuildException("Found multiple alias values for the same property: " + propertyAliases, new Object[0]);
        }
        return value;
    }

    public Object getProperty(String ... propertyAliases) throws BuildException {
        Object value = null;
        for (String alias : propertyAliases) {
            if (!this.getProperties().containsKey(alias)) continue;
            if (value == null) {
                value = this.getProperties().get(alias);
                continue;
            }
            throw new BuildException("Found multiple alias values for the same property: " + propertyAliases, new Object[0]);
        }
        return value;
    }

    public boolean containsType(Class<?> type) {
        boolean contains = false;
        for (Node child : this.getChildNodes()) {
            if (child.getMainObject() == null || !type.isAssignableFrom(child.getMainObject().getClass())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public String getKey() {
        return this.key;
    }

    public Set<String> getConsumedKeys() {
        return this.consumedKeys;
    }

    void setConsumedKeys(Set<String> consumedKeys) {
        this.consumedKeys = consumedKeys;
    }

    public boolean isUsePreInstantiatedRoot() {
        return this.usePreInstantiatedRoot;
    }

    public void setUsePreInstantiatedRoot(boolean usePreInstantiatedRoot) {
        this.usePreInstantiatedRoot = usePreInstantiatedRoot;
    }

    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public Object getCustomProperty(String key) {
        return this.customProperties.get(key);
    }

    public boolean isCustomPropertyEqualTo(String key, Object value) {
        Object pValue = this.customProperties.get(key);
        if (pValue == null) {
            return false;
        }
        return pValue.equals(value);
    }

    public String toString() {
        return MessageFormat.format("{0} node: {1}", this.getKey(), this.properties);
    }
}

