/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler.validation.validator;

import org.javabuilders.BuildException;
import org.javabuilders.BuildResult;
import org.javabuilders.NamedObjectProperty;
import org.javabuilders.handler.validation.BuilderValidators;
import org.javabuilders.handler.validation.ValidationMessage;
import org.javabuilders.handler.validation.ValidationMessageList;
import org.javabuilders.handler.validation.validator.AbstractValidator;

public class MaxValueValidator
extends AbstractValidator {
    private Object maxValue = null;
    private Long maxValueLong = null;
    private Double maxValueDouble = null;

    public MaxValueValidator(NamedObjectProperty property, String label, String messageFormat, BuildResult result, Object maxValue) {
        super(property, label, messageFormat, result);
        this.maxValue = maxValue;
        try {
            this.maxValueDouble = Double.parseDouble(maxValue.toString());
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (this.maxValueDouble == null) {
                this.maxValueLong = Long.parseLong(maxValue.toString());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.maxValueDouble == null && this.maxValueLong == null) {
            throw new BuildException("{0} is not a valid Long or Double comparison value", maxValue);
        }
    }

    @Override
    public void validate(Object value, ValidationMessageList list) {
        String sValue = String.valueOf(value);
        if (this.maxValueDouble != null) {
            try {
                Double dbl = Double.parseDouble(sValue);
                if (dbl > this.maxValueDouble) {
                    list.add(new ValidationMessage(this.getProperty(), this.getMessage(this.getLabel(), this.maxValue)));
                }
            }
            catch (NumberFormatException ex) {
                list.add(new ValidationMessage(this.getProperty(), this.getMessageForFormat(BuilderValidators.getDefaultNumericMessage(), this.getLabel())));
            }
        } else if (this.maxValueLong != null) {
            try {
                Long lng = Long.parseLong(sValue);
                if (lng > this.maxValueLong) {
                    list.add(new ValidationMessage(this.getProperty(), this.getMessage(this.getLabel(), this.maxValue)));
                }
            }
            catch (NumberFormatException ex) {
                list.add(new ValidationMessage(this.getProperty(), this.getMessageForFormat(BuilderValidators.getDefaultNumericMessage(), this.getLabel())));
            }
        }
    }
}

