/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.layout.mig;

import java.util.HashMap;
import java.util.Map;
import org.javabuilders.layout.ControlConstraint;
import org.javabuilders.layout.DefaultResize;
import org.javabuilders.layout.Size;

public class MigLayoutCommon {
    public static final String LAYOUT_CONSTRAINTS = "layoutConstraints";
    public static final String ROW_CONSTRAINTS = "rowConstraints";
    public static final String COLUMN_CONSTRAINTS = "columnConstraints";
    public static final String DEFAULT_ROW_COLUMN_CONSTRAINT = "[] ";
    private static final Map<DefaultResize, String> resizeConstraints = new HashMap<DefaultResize, String>();

    public static void handleResize(StringBuilder builder, ControlConstraint c, DefaultResize defaultResize, String additionalConstraints) {
        String resize = resizeConstraints.get((Object)defaultResize);
        if (c.getHSize() == Size.DEFAULT && c.getVSize() == Size.DEFAULT) {
            if (resize != null && (additionalConstraints == null || additionalConstraints.indexOf("grow") < 0)) {
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(resize);
            }
        } else {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            switch (c.getHSize()) {
                case MIN: {
                    builder.append("width min!");
                    break;
                }
                case PREF: {
                    builder.append("width pref!");
                    break;
                }
                case MAX: {
                    builder.append("growx");
                    break;
                }
                case DEFAULT: {
                    if (defaultResize == DefaultResize.BOTH || defaultResize == DefaultResize.X_AXIS) {
                        builder.append(resizeConstraints.get((Object)DefaultResize.X_AXIS));
                        break;
                    }
                    builder.append("width pref!");
                }
            }
            if (builder.length() > 0) {
                builder.append(", ");
            }
            switch (c.getVSize()) {
                case MIN: {
                    builder.append("height min!");
                    break;
                }
                case PREF: {
                    builder.append("height pref!");
                    break;
                }
                case MAX: {
                    builder.append("growy");
                    break;
                }
                case DEFAULT: {
                    if (defaultResize == DefaultResize.BOTH || defaultResize == DefaultResize.Y_AXIS) {
                        builder.append(resizeConstraints.get((Object)DefaultResize.Y_AXIS));
                        break;
                    }
                    builder.append("height pref!");
                }
            }
        }
    }

    static {
        resizeConstraints.put(DefaultResize.BOTH, "grow");
        resizeConstraints.put(DefaultResize.X_AXIS, "growx");
        resizeConstraints.put(DefaultResize.Y_AXIS, "growy");
    }
}

