/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.util;

import java.util.LinkedList;
import java.util.List;
import org.javabuilders.BuildProcess;
import org.javabuilders.IResourceFallback;

public class JBStringUtils {
    private static IResourceFallback resourceFallbackFun = new IResourceFallback(){

        @Override
        public String get(String key) {
            int pos = key.indexOf(".");
            if (pos < 0) {
                return JBStringUtils.getDisplayName(key);
            }
            return JBStringUtils.getDisplayName(key.substring(pos + 1));
        }
    };

    public static List<String> split(String input, char delimiter) {
        return JBStringUtils.split(input, delimiter, '\"');
    }

    public static List<String> split(String input, char delimiter, char quotes) {
        LinkedList<String> list = new LinkedList<String>();
        StringBuilder bld = new StringBuilder(input.length());
        boolean inQuotes = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == quotes) {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c == delimiter && !inQuotes) {
                list.add(bld.toString());
                bld.setLength(0);
                continue;
            }
            bld.append(c);
        }
        if (bld.length() > 0) {
            list.add(bld.toString());
        }
        return list;
    }

    public static List<String> splitPropertyName(String propertyName) {
        LinkedList<String> list = new LinkedList<String>();
        StringBuilder bld = new StringBuilder(propertyName.length());
        for (int i = 0; i < propertyName.length(); ++i) {
            String c = propertyName.substring(i, i + 1);
            if (c.toUpperCase().equals(c)) {
                list.add(bld.toString());
                bld.setLength(0);
                bld.append(c);
                continue;
            }
            if (i == 0) {
                bld.append(c.toUpperCase());
                continue;
            }
            bld.append(c);
        }
        if (bld.length() > 0) {
            list.add(bld.toString());
        }
        return list;
    }

    public static String getDisplayLabel(BuildProcess process, Class<?> type, String propertyName) {
        String label = null;
        label = process.getBuildResult().isInternationalizationActive() ? process.getBuildResult().getResource(String.format("%s.%s", type.getSimpleName(), propertyName), resourceFallbackFun) : resourceFallbackFun.get(propertyName);
        return label;
    }

    public static String getDisplayName(String propertyName) {
        List<String> parts = JBStringUtils.splitPropertyName(propertyName);
        StringBuilder bld = new StringBuilder(propertyName.length());
        for (String p : parts) {
            if (bld.length() > 0) {
                bld.append(" ");
            }
            bld.append(p);
        }
        return bld.toString();
    }
}

