/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.binding;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuildResult;
import org.javabuilders.BuilderConfig;
import org.javabuilders.NamedObjectProperty;
import org.javabuilders.Node;
import org.javabuilders.handler.binding.AbstractBuilderBindingsHandler;
import org.javabuilders.handler.binding.BindingSourceDefinition;
import org.javabuilders.util.BuilderUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeansBindingTypeHandler
extends AbstractBuilderBindingsHandler {
    public static final String MODEL = "model";
    private static final Logger logger = LoggerFactory.getLogger(BeansBindingTypeHandler.class);
    private static final BeansBindingTypeHandler singleton = new BeansBindingTypeHandler();
    private Map<String, AutoBinding.UpdateStrategy> updateStrategies = new HashMap<String, AutoBinding.UpdateStrategy>();

    public static BeansBindingTypeHandler getInstance() {
        return singleton;
    }

    private BeansBindingTypeHandler() {
        this.updateStrategies.put("read", AutoBinding.UpdateStrategy.READ);
        this.updateStrategies.put("readOnce", AutoBinding.UpdateStrategy.READ_ONCE);
        this.updateStrategies.put("readWrite", AutoBinding.UpdateStrategy.READ_WRITE);
    }

    public Node useExistingInstance(BuilderConfig config, BuildProcess process, Node parent, String key, Map<String, Object> typeDefinition, Object instance) throws BuildException {
        Node node = new Node(parent, key, typeDefinition);
        node.setMainObject(instance);
        BindingGroup bindingGroup = new BindingGroup();
        process.getBuildResult().setBindingContext((Object)bindingGroup);
        Map defs = this.getBindingDefinitions(node, process);
        for (NamedObjectProperty targetProperty : defs.keySet()) {
            BindingSourceDefinition sourceDef = (BindingSourceDefinition)defs.get(targetProperty);
            AutoBinding.UpdateStrategy strategy = this.updateStrategies.get(sourceDef.getUpdateStrategy());
            Object source = sourceDef.getSource();
            String sourceExpression = sourceDef.getBindingExpression();
            Object target = process.getByName(targetProperty.getName());
            String targetExpression = targetProperty.getPropertyExpression();
            Binding<Object, Object, Object, Object> binding = null;
            binding = MODEL.equals(targetExpression) ? this.createSwingBinding(source, sourceExpression, target, targetExpression, strategy, process) : this.createELPropertyBinding(source, sourceExpression, target, targetExpression, strategy, process);
            if (binding == null) continue;
            bindingGroup.addBinding(binding);
        }
        return node;
    }

    private Binding<Object, Object, Object, Object> createELPropertyBinding(Object sourceObject, String sourcePropertyPath, Object targetObject, String targetPropertyName, AutoBinding.UpdateStrategy strategy, BuildProcess process) {
        ELProperty<Object, Object> sourceProperty = this.getELProperty(sourcePropertyPath);
        ELProperty<Object, Object> targetProperty = this.getELProperty(targetPropertyName);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)strategy, (Object)sourceObject, sourceProperty, (Object)targetObject, targetProperty);
        BuilderUtils.fireBindingEvent((BuildResult)process.getBuildResult(), (Object)binding);
        binding.bind();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Bound [%s].%s to [%s].%s] with update strategy %s", sourceObject.getClass().getSimpleName(), sourceProperty, targetObject.getClass().getSimpleName(), targetProperty, strategy));
        }
        return binding;
    }

    private Binding<Object, Object, Object, Object> createSwingBinding(Object sourceObject, String sourcePropertyPath, Object targetObject, String targetPropertyName, AutoBinding.UpdateStrategy strategy, BuildProcess process) {
        JListBinding binding = null;
        if (targetObject instanceof JList) {
            JList list = (JList)targetObject;
            ELProperty<Object, Object> listProperty = this.getELProperty(sourcePropertyPath);
            binding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)strategy, (Object)sourceObject, listProperty, (JList)list);
            BuilderUtils.fireBindingEvent((BuildResult)process.getBuildResult(), (Object)binding);
            binding.bind();
        } else if (targetObject instanceof JComboBox) {
            JComboBox box = (JComboBox)targetObject;
            ELProperty<Object, Object> listProperty = this.getELProperty(sourcePropertyPath);
            binding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)strategy, (Object)sourceObject, listProperty, (JComboBox)box);
            BuilderUtils.fireBindingEvent((BuildResult)process.getBuildResult(), (Object)binding);
            binding.bind();
        } else if (targetObject instanceof JTable) {
            return this.createJTableBinding(sourceObject, sourcePropertyPath, (JTable)targetObject, targetPropertyName, strategy, process);
        }
        return binding;
    }

    private Binding<Object, Object, Object, Object> createJTableBinding(Object sourceObject, String sourcePropertyPath, JTable targetObject, String targetPropertyName, AutoBinding.UpdateStrategy strategy, BuildProcess result) {
        return null;
    }

    private ELProperty<Object, Object> getELProperty(String path) {
        ELProperty property = path.indexOf("${") >= 0 ? ELProperty.create((String)path) : ELProperty.create((String)String.format("${%s}", path));
        return property;
    }
}

