package net.oni2.aeinstaller.gui;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.RowSorter.SortKey;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

import net.oni2.aeinstaller.backend.Settings;
import net.oni2.aeinstaller.backend.StuffToRefactorLater;
import net.oni2.aeinstaller.backend.depot.DepotCacheUpdateProgressListener;
import net.oni2.aeinstaller.backend.depot.DepotConfig;
import net.oni2.aeinstaller.backend.depot.DepotManager;
import net.oni2.aeinstaller.backend.depot.model.NodeMod;
import net.oni2.aeinstaller.backend.depot.model.TaxonomyTerm;
import net.oni2.aeinstaller.gui.modtable.ModTableFilter;
import net.oni2.aeinstaller.gui.modtable.ModTableModel;
import net.oni2.aeinstaller.gui.settings.SettingsDialog;

import org.javabuilders.BuildResult;
import org.javabuilders.annotations.DoInBackground;
import org.javabuilders.event.BackgroundEvent;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class MainWin extends JFrame implements ListSelectionListener {
	private static final long serialVersionUID = -4027395051382659650L;

	private ResourceBundle bundle = ResourceBundle.getBundle(getClass()
			.getName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private JComboBox cmbModTypes;
	private JTable tblMods;
	private ModTableModel model;
	private TableRowSorter<ModTableModel> sorter;

	/**
	 * Constructor of main window.
	 */
	public MainWin() {
		this.setTitle(bundle.getString("frame.title") + " - v"
				+ bundle.getString("version"));

		initTable();
		initModTypeBox();
	}

	private void initModTypeBox() {
		int vid = DepotManager.getInstance()
				.getVocabulary(DepotConfig.MODTYPE_VOCAB).getVid();
		TreeMap<String, TaxonomyTerm> terms = new TreeMap<String, TaxonomyTerm>();
		terms.put(" ", new TaxonomyTerm(-1, vid, "-All-"));
		for (TaxonomyTerm t : DepotManager.getInstance()
				.getTaxonomyTermsByVocabulary(vid)) {
			terms.put(t.getName(), t);
		}
		for (TaxonomyTerm t : terms.values()) {
			cmbModTypes.addItem(t);
		}
		cmbModTypes.setSelectedIndex(0);
	}

	private void initTable() {
		tblMods.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		tblMods.getSelectionModel().addListSelectionListener(this);

		model = new ModTableModel();

		tblMods.setModel(model);

		sorter = new TableRowSorter<ModTableModel>(model);
		tblMods.setRowSorter(sorter);

		sorter.setRowFilter(new ModTableFilter(-1));

		sorter.setSortable(2, false);
		sorter.setComparator(1, new Comparator<String>() {

			@Override
			public int compare(String o1, String o2) {
				int i1 = Integer.parseInt(o1);
				int i2 = Integer.parseInt(o2);
				return i1 - i2;
			}
		});

		List<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
		sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
		sorter.setSortKeys(sortKeys);

		for (int i = 0; i < model.getColumnCount(); i++) {
			model.setColumnConstraints(i, tblMods.getColumnModel().getColumn(i));
		}

		// for (int i = 3; i > 0; i--) {
		// tblMods.getColumnModel().removeColumn(tblMods.getColumnModel().getColumn(i));
		// }
	}

	@SuppressWarnings("unused")
	private boolean closeFrames() {
		System.gc();
		for (Frame f : Frame.getFrames()) {
			if (f != this)
				f.dispose();
		}
		return true;
	}

	private void exit() {
		setVisible(false);
		dispose();
	}

	@SuppressWarnings("unused")
	private void saveLocalData() {
		Settings.getInstance().serializeToFile();
		DepotManager.getInstance().saveToFile(
				new File(Settings.getDepotCacheFilename()));
	}

	@SuppressWarnings("unused")
	private boolean validatePath() {
		if (!StuffToRefactorLater.verifyRunningDirectory()) {
			JOptionPane.showMessageDialog(this,
					bundle.getString("invalidPath.text"),
					bundle.getString("invalidPath.title"),
					JOptionPane.ERROR_MESSAGE);
			if (!Settings.getDebug()) {
				exit();
				return false;
			}
		}
		return true;
	}

	@DoInBackground(progressMessage = "updateDepot.title", cancelable = false, indeterminateProgress = false)
	private void execDepotUpdate(final BackgroundEvent evt) {
		try {
			DepotManager.getInstance().updateInformation(false,
					new DepotCacheUpdateProgressListener() {

						@Override
						public void cacheUpdateProgress(String stepName,
								int current, int total) {
							evt.setProgressEnd(total);
							evt.setProgressValue(current);
							evt.setProgressMessage(stepName);
						}
					});
			model.reloadData();
			DepotManager.getInstance().printStats();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@SuppressWarnings("unused")
	private void checkUpdates() {
		if (Settings.getInstance().get("notifyupdates", true)) {
		}
	}

	@SuppressWarnings("unused")
	private void focus() {
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				toFront();
				repaint();
			}
		});

	}

	@SuppressWarnings("unused")
	private void showSettings() {
		SettingsDialog.openWindow();
	}

	@SuppressWarnings("unused")
	private void modTypeSelection() {
		TaxonomyTerm t = (TaxonomyTerm) cmbModTypes.getSelectedItem();
		sorter.setRowFilter(new ModTableFilter(t.getTid()));
	}

	@SuppressWarnings("unused")
	private void sortAlpha() {
		SortOrder order = SortOrder.ASCENDING;
		for (SortKey sk : sorter.getSortKeys()) {
			if (sk.getColumn() == 0) {
				if (sk.getSortOrder() == SortOrder.ASCENDING)
					order = SortOrder.DESCENDING;
			}
		}
		List<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
		sortKeys.add(new RowSorter.SortKey(0, order));
		sorter.setSortKeys(sortKeys);
	}

	@SuppressWarnings("unused")
	private void sortPackageNumber() {
		SortOrder order = SortOrder.ASCENDING;
		for (SortKey sk : sorter.getSortKeys()) {
			if (sk.getColumn() == 1) {
				if (sk.getSortOrder() == SortOrder.ASCENDING)
					order = SortOrder.DESCENDING;
			}
		}
		List<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
		sortKeys.add(new RowSorter.SortKey(1, order));
		sorter.setSortKeys(sortKeys);
	}

	@Override
	public void valueChanged(ListSelectionEvent arg0) {
		int viewRow = tblMods.getSelectedRow();
		if (viewRow < 0)
			// TODO
			return;
		int modelRow = tblMods.convertRowIndexToModel(viewRow);
		NodeMod mod = (NodeMod) model.getValueAt(modelRow, -1);
		// TODO
	}
}
