/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.swing.handler.property;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ActionMapUIResource;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.BuilderConfig;
import org.javabuilders.Node;
import org.javabuilders.handler.AbstractPropertyHandler;
import org.javabuilders.swing.SwingJavaBuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractButtonTextHandler
extends AbstractPropertyHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractButtonTextHandler.class);
    public static final String TEXT = "text";

    public AbstractButtonTextHandler() {
        super(new String[]{TEXT});
    }

    public void handle(BuilderConfig config, BuildProcess process, Node node, String key) throws BuildException {
        String text = String.valueOf(node.getProperties().get(key));
        final AbstractButton button = (AbstractButton)node.getMainObject();
        SwingJavaBuilderUtils.ActionDefinition def = SwingJavaBuilderUtils.getActionDefintion(text);
        button.setText(def.getText());
        if (def.getMnemonic() != null) {
            button.setMnemonic(def.getMnemonic());
        }
        if (def.getAccelerator() != null) {
            if (button instanceof JMenuItem && !(button instanceof JMenu)) {
                JMenuItem menuItem = (JMenuItem)button;
                menuItem.setAccelerator(def.getAccelerator());
            } else if (button instanceof JButton) {
                ComponentInputMap keyMap = new ComponentInputMap(button);
                ((InputMap)keyMap).put(def.getAccelerator(), "action");
                ActionMapUIResource actionMap = new ActionMapUIResource();
                actionMap.put("action", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ActionEvent evt = new ActionEvent(button, 1001, "action");
                        if (button.getActionListeners() != null) {
                            for (ActionListener listener : button.getActionListeners()) {
                                listener.actionPerformed(evt);
                            }
                        }
                        if (button.getAction() != null && !button.getAction().equals(this)) {
                            button.getAction().actionPerformed(evt);
                        }
                    }
                });
                SwingUtilities.replaceUIActionMap(button, actionMap);
                SwingUtilities.replaceUIInputMap(button, 2, keyMap);
                if (button.getToolTipText() == null || button.getToolTipText().length() == 0) {
                    button.setToolTipText(def.getAcceleratorText());
                }
            } else {
                LOG.warn("Ignored accelerator: can only be set on JMenuItem(s) or JButton(s): " + text);
            }
        }
    }
}

