/*
 * Decompiled with CFR 0.152.
 */
package org.javabuilders.handler;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.javabuilders.BuildException;
import org.javabuilders.BuildProcess;
import org.javabuilders.Node;
import org.javabuilders.TypeDefinition;
import org.javabuilders.handler.ITypeAsValueHandler;

public class IntegerAsValueHandler
implements ITypeAsValueHandler<Integer> {
    private static String regex = "\\d+|[a-zA-Z0-9_]+";
    private static final IntegerAsValueHandler singleton = new IntegerAsValueHandler();

    public static IntegerAsValueHandler getInstance() {
        return singleton;
    }

    private IntegerAsValueHandler() {
    }

    @Override
    public String getInputValueSample() {
        return "3 | SOME_CONSTANT_VALUE | someConstantValue";
    }

    @Override
    public String getRegex() {
        return regex;
    }

    @Override
    public Integer getValue(BuildProcess process, Node node, String key, Object inputValue) throws BuildException {
        Integer value = null;
        if (inputValue instanceof Integer) {
            value = (Integer)inputValue;
        } else if (inputValue instanceof Long) {
            Long lValue = (Long)inputValue;
            value = lValue.intValue();
        } else if (inputValue instanceof String) {
            Field[] fields;
            Class<?> mainClass = node.getMainObject().getClass();
            Class<?> constantsClass = TypeDefinition.getPropertyConstantsClass(process.getConfig(), mainClass, key);
            if (constantsClass == null) {
                constantsClass = mainClass;
            }
            for (Field field : fields = constantsClass.getFields()) {
                int mod = field.getModifiers();
                if (!Modifier.isPublic(mod) || !Modifier.isFinal(mod) || !Modifier.isStatic(mod) || !field.getType().equals(Integer.TYPE)) continue;
                String name = field.getName();
                String camelCase = TypeDefinition.getShortEnumConstant(field.getName());
                if (!inputValue.equals(name) && !inputValue.equals(camelCase)) continue;
                try {
                    value = (Integer)field.get(node.getMainObject());
                    break;
                }
                catch (Exception e) {
                    throw new BuildException(e);
                }
            }
        }
        if (value != null) {
            return value;
        }
        throw new BuildException("Unable to map value \"{0}\" to Integer", inputValue);
    }

    @Override
    public Class<?> getApplicableClass() {
        return Integer.TYPE;
    }
}

