package net.oni2.aeinstaller.backend.depot.model;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class TaxonomyVocabulary {
	private int vid;
	private String name;
	private String machine_name;
	private String description;
	private int hierarchy;
	private String uri;

	/**
	 * @param json
	 *            JSONObject containing the item
	 * @throws JSONException
	 *             If a key can't be found
	 */
	public TaxonomyVocabulary(JSONObject json) throws JSONException {
		vid = json.getInt("vid");
		name = json.getString("name");
		machine_name = json.getString("machine_name");
		description = json.getString("description");
		hierarchy = json.getInt("hierarchy");
		uri = json.getString("uri");
	}

	/**
	 * @return the vocabulary ID (vid)
	 */
	public int getVid() {
		return vid;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the machine_name
	 */
	public String getMachine_name() {
		return machine_name;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @return the hierarchy level
	 */
	public int getHierarchy() {
		return hierarchy;
	}

	/**
	 * @return the uri
	 */
	public String getUri() {
		return uri;
	}
}
