package net.oni2.aeinstaller.gui.modtable;

import java.util.HashSet;

import javax.swing.RowFilter;

import net.oni2.aeinstaller.backend.Settings;
import net.oni2.aeinstaller.backend.depot.DepotManager;
import net.oni2.aeinstaller.backend.depot.model.NodeMod;

/**
 * @author Christian Illy
 */
public class ModTableFilter extends RowFilter<ModTableModel, Integer> {
	int type = -1;

	/**
	 * @param type
	 *            Type of mods to show (-1 for all)
	 */
	public ModTableFilter(int type) {
		super();
		this.type = type;
	}

	@Override
	public boolean include(
			javax.swing.RowFilter.Entry<? extends ModTableModel, ? extends Integer> entry) {
		NodeMod mod = (NodeMod) entry.getModel().getValueAt(
				entry.getIdentifier(), -1);

		if (!DepotManager.getInstance().isModValidOnPlatform(mod,
				Settings.getPlatform()))
			return false;

		if (type < 0)
			return true;

		HashSet<Integer> types = new HashSet<Integer>();
		types.add(type);
		return DepotManager.getInstance().isModOfType(mod, types, false);
	}
}
