package net.oni2.aeinstaller.gui.settings;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;

import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import net.oni2.aeinstaller.backend.Settings;

import org.javabuilders.BuildResult;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class SettingsDialog extends JFrame {
	private static final long serialVersionUID = -5719515325671846620L;

	private ResourceBundle bundle = ResourceBundle.getBundle(getClass()
			.getName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private static SettingsDialog openWindow = null;

	private JComboBox cmbLaF;
	private LaFComboModel laFModel;

	/**
	 * Open the Settings dialog if not currently opened or brings the existing
	 * one to front
	 */
	public static void openWindow() {
		if (openWindow != null) {
			SwingUtilities.invokeLater(new Runnable() {

				@Override
				public void run() {
					openWindow.toFront();
					openWindow.repaint();
				}
			});
		} else {
			new SettingsDialog().setVisible(true);
		}
	}

	private SettingsDialog() {
		openWindow = this;
		setMinimumSize(new Dimension(500, (int) getSize().getHeight() + 0));

		AbstractAction closeAction = new AbstractAction() {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		};
		KeyStroke ksCtrlW = KeyStroke
				.getKeyStroke('W', KeyEvent.CTRL_DOWN_MASK);
		getRootPane()
				.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
				.put(ksCtrlW, "close");
		getRootPane().getActionMap().put("close", closeAction);

		initValues();
	}

	private void initValues() {
		Settings set = Settings.getInstance();

		laFModel = new LaFComboModel();
		cmbLaF.setModel(laFModel);
	}

	@SuppressWarnings("unused")
	private void close() {
		openWindow = null;
	}

	@SuppressWarnings("unused")
	private boolean save() {
		Settings set = Settings.getInstance();

		String oldLaf = set.get("lookandfeel",
				UIManager.getSystemLookAndFeelClassName());
		String newLaf = laFModel.getSelectedClassName();

		if (!newLaf.equals(oldLaf)) {
			set.put("lookandfeel", newLaf);
			JOptionPane.showMessageDialog(this,
					bundle.getString("newLaF.text"),
					bundle.getString("newLaF.title"),
					JOptionPane.INFORMATION_MESSAGE);
		}

		return true;
	}

}
