package net.oni2.aeinstaller.backend.depot.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class NodeMod extends Node {
	private Vector<NodeField_Upload> uploads = new Vector<NodeField_Upload>();
	private HashMap<Integer, HashSet<Integer>> taxonomyTerms = new HashMap<Integer, HashSet<Integer>>();
	private HashMap<String, String> fields = new HashMap<String, String>();

	/**
	 * @param json
	 *            JSON object of Mod-node to parse
	 * @throws JSONException
	 *             On key not found / wrong type
	 */
	public NodeMod(JSONObject json) throws JSONException {
		super(json);

		Object uploadObj = json.get("upload");
		if (uploadObj instanceof JSONObject) {
			JSONArray jUploads = ((JSONObject) uploadObj).getJSONArray("und");
			for (int i = 0; i < jUploads.length(); i++) {
				NodeField_Upload up = new NodeField_Upload(
						jUploads.getJSONObject(i));
				if (up.getDisplay() != 0) {
					uploads.add(up);
				}
			}
		}

		for (Object key : json.keySet()) {
			String keyS = ((String) key).toLowerCase();
			Object val = json.get(keyS);
			if (keyS.startsWith("field_")) {
				String fName = keyS.substring(keyS.indexOf("_") + 1);
				String value = "";
				if (val instanceof JSONObject) {
					value = ((JSONObject) val).getJSONArray("und")
							.getJSONObject(0).getString("value");
				}
				fields.put(fName, value);
			}

			if (keyS.startsWith("taxonomy_vocabulary_")) {
				int vid = Integer
						.parseInt(keyS.substring(keyS.lastIndexOf("_") + 1));
				HashSet<Integer> values = new HashSet<Integer>();
				if (val instanceof JSONObject) {
					JSONArray ja = ((JSONObject) val).getJSONArray("und");
					for (int i = 0; i < ja.length(); i++) {
						values.add(ja.getJSONObject(i).getInt("tid"));
					}
				}
				taxonomyTerms.put(vid, values);
			}
		}
	}

	/**
	 * @return the uploads
	 */
	public Vector<NodeField_Upload> getUploads() {
		return uploads;
	}

	/**
	 * @return the taxonomyTerms
	 */
	public HashMap<Integer, HashSet<Integer>> getTaxonomyTerms() {
		return taxonomyTerms;
	}

	/**
	 * @return the fields
	 */
	public HashMap<String, String> getFields() {
		return fields;
	}
}
