package net.oni2.aeinstaller.gui;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

import net.oni2.aeinstaller.backend.Settings;
import net.oni2.aeinstaller.backend.depot.DepotCacheUpdateProgressListener;
import net.oni2.aeinstaller.backend.depot.DepotConfig;
import net.oni2.aeinstaller.backend.depot.DepotManager;
import net.oni2.aeinstaller.backend.depot.model.NodeMod;
import net.oni2.aeinstaller.backend.depot.model.TaxonomyTerm;
import net.oni2.aeinstaller.backend.depot.model.TaxonomyVocabulary;
import net.oni2.aeinstaller.gui.modtable.ModTableFilter;
import net.oni2.aeinstaller.gui.modtable.ModTableModel;
import net.oni2.aeinstaller.gui.settings.SettingsDialog;

import org.javabuilders.BuildResult;
import org.javabuilders.annotations.DoInBackground;
import org.javabuilders.event.BackgroundEvent;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class MainWin extends JFrame {
	private static final long serialVersionUID = -4027395051382659650L;

	private ResourceBundle bundle = ResourceBundle.getBundle(getClass()
			.getName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private JSplitPane contents;

	private JComboBox cmbModTypes;
	private JTable tblMods;
	private ModTableModel model;
	private TableRowSorter<ModTableModel> sorter;

	private JLabel lblSubmitterVal;
	private JLabel lblCreatorVal;
	private JLabel lblFilesVal;
	private JLabel lblIdVal;
	private HTMLLinkLabel lblDescriptionVal;

	/**
	 * Constructor of main window.
	 */
	public MainWin() {
		this.setTitle(bundle.getString("frame.title") + " - v"
				+ bundle.getString("version"));

		contents.setDividerLocation(400);
		initTable();
		initModTypeBox();
	}

	private void initModTypeBox() {
		cmbModTypes.removeAllItems();

		TaxonomyVocabulary tv = DepotManager.getInstance().getVocabulary(
				DepotConfig.getVocabularyName_ModType());
		if (tv == null)
			return;

		int vid = tv.getVid();
		TreeMap<String, TaxonomyTerm> terms = new TreeMap<String, TaxonomyTerm>();
		terms.put(" ", new TaxonomyTerm(-1, vid, "-All-"));
		for (TaxonomyTerm t : DepotManager.getInstance()
				.getTaxonomyTermsByVocabulary(vid)) {
			terms.put(t.getName(), t);
		}
		for (TaxonomyTerm t : terms.values()) {
			cmbModTypes.addItem(t);
		}
		cmbModTypes.setSelectedIndex(0);
	}

	private void initTable() {
		tblMods.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		tblMods.getSelectionModel().addListSelectionListener(
				new ListSelectionListener() {

					@Override
					public void valueChanged(ListSelectionEvent e) {
						int viewRow = tblMods.getSelectedRow();
						if (viewRow < 0) {
							modSelection(null);
						} else {
							int modelRow = tblMods
									.convertRowIndexToModel(viewRow);
							NodeMod mod = (NodeMod) model.getValueAt(modelRow,
									-1);
							modSelection(mod);
						}
					}
				});

		model = new ModTableModel();

		tblMods.setModel(model);

		sorter = new TableRowSorter<ModTableModel>(model);
		tblMods.setRowSorter(sorter);

		sorter.setRowFilter(new ModTableFilter(-1));

		sorter.setSortable(2, false);
		sorter.setComparator(1, new Comparator<String>() {

			@Override
			public int compare(String o1, String o2) {
				int i1 = Integer.parseInt(o1);
				int i2 = Integer.parseInt(o2);
				return i1 - i2;
			}
		});

		List<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
		sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
		sorter.setSortKeys(sortKeys);

		for (int i = 0; i < model.getColumnCount(); i++) {
			model.setColumnConstraints(i, tblMods.getColumnModel().getColumn(i));
		}

		// for (int i = 3; i > 0; i--) {
		// tblMods.getColumnModel().removeColumn(tblMods.getColumnModel().getColumn(i));
		// }
	}

	@SuppressWarnings("unused")
	private boolean closeFrames() {
		System.gc();
		for (Frame f : Frame.getFrames()) {
			if (f != this)
				f.dispose();
		}
		return true;
	}

	@SuppressWarnings("unused")
	private void exit() {
		setVisible(false);
		dispose();
	}

	@SuppressWarnings("unused")
	private void saveLocalData() {
		Settings.getInstance().serializeToFile();
		DepotManager.getInstance().saveToFile(
				new File(Settings.getDepotCacheFilename()));
	}

	@DoInBackground(progressMessage = "updateDepot.title", cancelable = false, indeterminateProgress = false)
	private void execDepotUpdate(final BackgroundEvent evt) {
		try {
			DepotManager.getInstance().updateInformation(false,
					new DepotCacheUpdateProgressListener() {

						@Override
						public void cacheUpdateProgress(String stepName,
								int current, int total) {
							evt.setProgressEnd(total);
							evt.setProgressValue(current);
							evt.setProgressMessage(stepName);
						}
					});
			model.reloadData();
			initModTypeBox();
			tblMods.setVisible(true);
			DepotManager.getInstance().printStats();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@SuppressWarnings("unused")
	private void checkUpdates() {
		if (Settings.getInstance().get("notifyupdates", true)) {
		}
	}

	@SuppressWarnings("unused")
	private void focus() {
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				toFront();
				repaint();
			}
		});

	}

	@SuppressWarnings("unused")
	private void showSettings() {
		SettingsDialog.openWindow();
	}

	private void modSelection(NodeMod n) {
		lblSubmitterVal.setText("");
		lblCreatorVal.setText("");
		lblIdVal.setText("");
		lblFilesVal.setText("");
		lblDescriptionVal.setText("");
		if (n != null) {
			lblSubmitterVal.setText(n.getName());
			lblCreatorVal.setText(n.getFields().get("creator"));
			lblIdVal.setText(Integer.toString(n.getNid()));
			lblFilesVal.setText(Integer.toString(n.getUploads().size()));
			if (n.getBody() != null)
				lblDescriptionVal.setText(n.getBody().getSafe_value());
		}
		// TODO
	}

	@SuppressWarnings("unused")
	private void modTypeSelection() {
		TaxonomyTerm t = (TaxonomyTerm) cmbModTypes.getSelectedItem();
		if (t != null)
			sorter.setRowFilter(new ModTableFilter(t.getTid()));
		else
			sorter.setRowFilter(new ModTableFilter(-1));
	}
}