package net.oni2.aeinstaller.gui.settings;

import java.util.HashSet;
import java.util.Vector;

import javax.swing.ComboBoxModel;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;
import javax.swing.event.ListDataListener;

import net.oni2.aeinstaller.backend.Settings;

/**
 * Comboboxmodel for Look and Feel selection
 * 
 * @author Christian Illy
 */
public class LaFComboModel implements ComboBoxModel {

	Vector<LookAndFeelInfo> items;
	HashSet<ListDataListener> listeners;
	int selected;

	/**
	 * Create a new LaF model
	 */
	public LaFComboModel() {
		listeners = new HashSet<ListDataListener>();
		items = new Vector<LookAndFeelInfo>();
		for (LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels())
			items.add(laf);

		
		String laf = Settings.getInstance().get("lookandfeel",
				UIManager.getLookAndFeel().getClass().getName());

		if (items.size() > 0)
			selected = 0;
		else
			selected = -1;

		for (int i = 0; i < items.size(); i++) {
			String iLaF = items.get(i).getClassName();
			if (iLaF.equals(laf)) {
				selected = i;
				break;
			}
		}
	}

	@Override
	public int getSize() {
		return items.size();
	}

	@Override
	public Object getElementAt(int index) {
		return items.get(index).getName();
	}

	/**
	 * Get class name for the selected LaF
	 * 
	 * @return LaF class name
	 */
	public String getSelectedClassName() {
		return items.get(selected).getClassName();
	}

	@Override
	public void addListDataListener(ListDataListener arg0) {
		listeners.add(arg0);
	}

	@Override
	public void removeListDataListener(ListDataListener arg0) {
		listeners.remove(arg0);
	}

	@Override
	public Object getSelectedItem() {
		if (selected >= 0)
			return getElementAt(selected);
		else
			return null;
	}

	@Override
	public void setSelectedItem(Object anItem) {
		for (int i = 0; i < items.size(); i++) {
			if (getElementAt(i).equals(anItem)) {
				selected = i;
				return;
			}
		}
		selected = -1;
	}
}
