package net.oni2.aeinstaller.gui;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.io.IOException;
import java.net.URISyntaxException;

import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;

import net.oni2.aeinstaller.backend.ColorCopy;

/**
 * @author Christian Illy
 */
public class HTMLLinkLabel extends JEditorPane {
	private static final long serialVersionUID = 2416829757362043910L;

	String prefix;
	String suffix;

	/**
	 * Create a new HTMLLinkLabel
	 */
	public HTMLLinkLabel() {
		super();

		((DefaultCaret) this.getCaret()).setUpdatePolicy(DefaultCaret.NEVER_UPDATE);

		setContentType("text/html");

		JLabel label = new JLabel();
		Font font = label.getFont();

		StringBuffer style = new StringBuffer("font-family:" + font.getFamily()
				+ ";");
		style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
		style.append("font-size:" + font.getSize() + "pt;");

		prefix = "<html><body style=\"" + style + "\">";
		suffix = "</body></html>";

		addHyperlinkListener(new HyperlinkListener() {

			@Override
			public void hyperlinkUpdate(HyperlinkEvent e) {
				if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED))
					try {
						Desktop.getDesktop().browse(e.getURL().toURI());
					} catch (IOException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					} catch (URISyntaxException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
			}
		});
		setEditable(false);

		Color bgColor = ColorCopy.copyColor(new JFrame().getBackground());
		UIDefaults defaults = new UIDefaults();
		defaults.put("EditorPane[Enabled].backgroundPainter", bgColor);
		putClientProperty("Nimbus.Overrides", defaults);
		putClientProperty("Nimbus.Overrides.InheritDefaults", true);
		setBackground(bgColor);
	}

	@Override
	public void setText(String t) {
		super.setText(prefix + t + suffix);
	}

}
