package net.oni2.aeinstaller;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ResourceBundle;

import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;

import net.oni2.aeinstaller.backend.Settings;
import net.oni2.aeinstaller.backend.Settings.Platform;
import net.oni2.aeinstaller.backend.StuffToRefactorLater;
import net.oni2.aeinstaller.backend.depot.DepotManager;
import net.oni2.aeinstaller.gui.MainWin;

import org.javabuilders.swing.SwingJavaBuilder;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.DefaultApplication;

/**
 * @author Christian Illy
 */
public class AEInstaller2 {

	private static ResourceBundle imagesBundle = ResourceBundle
			.getBundle(AEInstaller2.class.getPackage().getName() + ".Images");
	private static ResourceBundle basicBundle = ResourceBundle
			.getBundle(AEInstaller2.class.getPackage().getName()
					+ ".AEInstaller");

	private static Application app = null;

	private static void initMacOS() {
		System.setProperty("apple.laf.useScreenMenuBar", "true");
		System.setProperty("com.apple.mrj.application.apple.menu.about.name",
				basicBundle.getString("appname"));
		app = new DefaultApplication();

		URL icon = AEInstaller2.class.getResource("images/AElogo.png");
		try {
			BufferedImage img = ImageIO.read(icon);
			app.setApplicationIconImage(img);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/**
	 * @param args
	 *            Command line arguments
	 */
	public static void main(String[] args) {
		new File(Settings.getPrefsPath()).mkdirs();
		new File(Settings.getDownloadPath()).mkdirs();

		boolean debug = false;
		for (String a : args)
			if (a.equalsIgnoreCase("-debug"))
				debug = true;
		if (!debug) {
			try {
				System.setOut(new PrintStream(Settings.getPrefsPath()
						+ "aei_output.log"));
				System.setErr(new PrintStream(Settings.getPrefsPath()
						+ "aei_error.log"));
			} catch (FileNotFoundException e1) {
				e1.printStackTrace();
			}
		}

		if (Settings.getPlatform() == Platform.MACOS)
			initMacOS();

		Settings.deserializeFromFile();
		Settings.setDebug(debug);
		DepotManager.getInstance().loadFromFile(
				new File(Settings.getDepotCacheFilename()));

		SwingJavaBuilder.getConfig().addResourceBundle(imagesBundle);
		SwingJavaBuilder.getConfig().addResourceBundle(basicBundle);
		SwingJavaBuilder.getConfig().setMarkInvalidResourceBundleKeys(true);
		SwingJavaBuilder.getConfig().addType("JToolBarSeparator",
				JToolBar.Separator.class);

		System.setProperty("networkaddress.cache.ttl", "5");
		System.setProperty("networkaddress.cache.negative.ttl", "1");
		
		try {
			String laf = Settings.getInstance().get("lookandfeel",
					(String) null);
			if (laf == null) {
				if (Settings.getPlatform() == Platform.MACOS) {
					laf = UIManager.getSystemLookAndFeelClassName();
				} else {
					for (LookAndFeelInfo lafInfo : UIManager
							.getInstalledLookAndFeels()) {
						if (lafInfo.getName().equals("Nimbus"))
							laf = lafInfo.getClassName();
					}
				}
			}
			if (laf == null)
				laf = UIManager.getSystemLookAndFeelClassName();
			UIManager.setLookAndFeel(laf);
		} catch (Exception e) {
			e.printStackTrace();
		}
		JFrame.setDefaultLookAndFeelDecorated(true);

		// TODO
		System.out.println("JarPath:   " + Settings.getJarPath());
		System.out.println("PrefsPath: " + Settings.getPrefsPath());
		System.out.println("DataPath:  " + Settings.getDataPath());
		System.out.println("DownPath:  " + Settings.getDownloadPath());
		System.out.println("TempPath:  " + Settings.getTempPath());
		System.out.println("ValidPath: "
				+ StuffToRefactorLater.verifyRunningDirectory());

		if (!StuffToRefactorLater.verifyRunningDirectory()) {
			JOptionPane.showMessageDialog(null,
					basicBundle.getString("invalidPath.text"),
					basicBundle.getString("invalidPath.title"),
					JOptionPane.ERROR_MESSAGE);
			if (!Settings.getDebug()) {
				return;
			}
		}

		SwingUtilities.invokeLater(new Runnable() {

			public void run() {
				try {
					MainWin mw = new MainWin();
					if (app != null) {
						app.addAboutMenuItem();
						app.setEnabledAboutMenu(true);
						app.addPreferencesMenuItem();
						app.setEnabledPreferencesMenu(true);
						app.addApplicationListener(mw);
					}
					mw.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});

	}
}
