package net.oni2.aeinstaller.gui.modtable;

import java.util.ResourceBundle;
import java.util.Vector;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

import net.oni2.aeinstaller.backend.depot.DepotConfig;
import net.oni2.aeinstaller.backend.depot.DepotManager;
import net.oni2.aeinstaller.backend.depot.model.NodeMod;

/**
 * @author Christian Illy
 */
public class ModTableModel extends AbstractTableModel {

	private static final long serialVersionUID = -8278155705802697354L;

	private ResourceBundle bundle = ResourceBundle.getBundle(getClass()
			.getName());

	private Vector<NodeMod> items;
	private Vector<Boolean> install;
	private int vocabModTypeID = -1;
	private int vocabPlatformID = -1;

	/**
	 * Create a new model
	 */
	public ModTableModel() {
		reloadData();
	}

	@Override
	public Object getValueAt(int row, int col) {
		NodeMod node = items.get(row);
		switch (col) {
			case -1:
				return node;
			case 0:
				return node.getTitle();
			case 1:
				return node.getFields().get("package_number");
			case 2:
				String type = "";
				if (vocabModTypeID < 0) {
					vocabModTypeID = DepotManager
							.getInstance()
							.getVocabulary(
									DepotConfig.getVocabularyName_ModType())
							.getVid();
				}
				for (int tid : node.getTaxonomyTerms().get(vocabModTypeID)) {
					if (type.length() > 0)
						type += ", ";
					type += DepotManager.getInstance().getTaxonomyTerm(tid)
							.getName();
				}
				return type;
			case 3:
				if (vocabPlatformID < 0) {
					vocabPlatformID = DepotManager
							.getInstance()
							.getVocabulary(
									DepotConfig.getVocabularyName_Platform())
							.getVid();
				}
				int tid = node.getTaxonomyTerms().get(vocabPlatformID)
						.iterator().next();
				return DepotManager.getInstance().getTaxonomyTerm(tid)
						.getName();
			case 4:
				return install.get(row);
		}
		return null;
	}

	@Override
	public String getColumnName(int col) {
		switch (col) {
			case 0:
				return bundle.getString("mod.name");
			case 1:
				return bundle.getString("mod.package_number");
			case 2:
				return bundle.getString("mod.type");
			case 3:
				return bundle.getString("mod.platform");
			case 4:
				return bundle.getString("mod.install");
		}
		return null;
	}

	@Override
	public int getRowCount() {
		return items.size();
	}

	@Override
	public int getColumnCount() {
		return 5;
	}

	@Override
	public Class<?> getColumnClass(int col) {
		switch (col) {
			case 0:
				return String.class;
			case 1:
				return Integer.class;
			case 2:
				return String.class;
			case 3:
				return String.class;
			case 4:
				return Boolean.class;
		}
		return null;
	}

	/**
	 * Set the constraints on the columns size for the given column
	 * 
	 * @param colNum
	 *            Column number
	 * @param col
	 *            Column object
	 */
	public void setColumnConstraints(int colNum, TableColumn col) {
		int w;
		switch (colNum) {
			case 0:
				col.setPreferredWidth(150);
				break;
			case 1:
				w = 55;
				col.setPreferredWidth(w);
				col.setMinWidth(w);
				col.setMaxWidth(w);
				break;
			case 2:
				col.setPreferredWidth(100);
				break;
			case 3:
				w = 70;
				col.setPreferredWidth(w);
				col.setMinWidth(w);
				col.setMaxWidth(w);
				break;
			case 4:
				w = 60;
				col.setPreferredWidth(w);
				col.setMinWidth(w);
				col.setMaxWidth(w);
				break;
		}
	}

	/**
	 * Reload the nodes data after an update to the cache
	 */
	public void reloadData() {
		items = DepotManager.getInstance().getModPackageNodes();
		install = new Vector<Boolean>();
		// TODO check installed
		for (int i = 0; i < items.size(); i++) {
			install.add(i, false);
		}
	}

	/**
	 * Get the items vector
	 * 
	 * @return Items
	 */
	public Vector<NodeMod> getItems() {
		return items;
	}

	@Override
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return columnIndex == 4;
	}

	@Override
	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
		super.setValueAt(aValue, rowIndex, columnIndex);
		if (columnIndex == 4) {
			install.set(rowIndex, (Boolean) aValue);
		}
	}

}
