package net.oni2.aeinstaller.backend.oni;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Scanner;

import net.oni2.aeinstaller.backend.Paths;

import org.apache.commons.io.FileUtils;

/**
 * @author Christian Illy
 */
public class Installer {
	/**
	 * @return Is Edition Core initialized
	 */
	public static boolean isEditionInitialized() {
		File editionGDF = Paths.getEditionGDF();
		File vanillaDats = Paths.getVanillaGDF();
		return editionGDF.exists() && vanillaDats.exists();
	}

	private static void createEmptyPath(File path) throws IOException {
		if (path.exists())
			FileUtils.deleteDirectory(path);
		path.mkdirs();
	}

	/**
	 * Initializes the Edition core
	 */
	public static void initializeEdition() {
		File init = new File(Paths.getTempPath(), "init");
		try {
			createEmptyPath(Paths.getEditionGDF());
			createEmptyPath(Paths.getVanillaOnisPath());
			createEmptyPath(init);

			for (File f : Paths.getVanillaGDF().listFiles(new FilenameFilter() {
				@Override
				public boolean accept(File dir, String name) {
					return name.endsWith(".dat");
				}
			})) {
				String levelName = f.getName().substring(0,
						f.getName().indexOf('.'));
				int levelNumber = -1;

				Scanner fi = new Scanner(levelName);
				fi.useDelimiter("[^\\p{Alnum}]");
				while (fi.hasNextInt()) {
					levelNumber = fi.nextInt();
				}

				OniSplit.export(new File(init, levelName), f);
			}

			// TODO: FileUtils.deleteDirectory(Paths.getEditionGDF());
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
