package net.oni2.aeinstaller.backend.oni;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Vector;

import net.oni2.aeinstaller.backend.Paths;
import net.oni2.aeinstaller.backend.Settings;
import net.oni2.aeinstaller.backend.Settings.Architecture;
import net.oni2.aeinstaller.backend.Settings.Platform;
import net.oni2.aeinstaller.backend.WinRegistry;
import net.oni2.aeinstaller.backend.app_launcher.QuickAppExecution;

/**
 * @author Christian Illy
 */
public class OniSplit {

	/**
	 * @return is a .NET implementation installed?
	 */
	public static boolean isDotNETInstalled() {
		switch (Settings.getPlatform()) {
			case WIN:
				try {
					int view = WinRegistry.KEY_WOW64_32KEY;
					if (Settings.getArchitecture() == Architecture.AMD64)
						view = WinRegistry.KEY_WOW64_64KEY;

					Map<String, String> m = WinRegistry
							.readStringValues(
									WinRegistry.HKEY_LOCAL_MACHINE,
									"Software\\Microsoft\\NET Framework Setup\\NDP\\v2.0.50727",
									view);
					return m != null;
				} catch (IllegalArgumentException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (Exception e) {
					if (!e.getMessage()
							.equals("Registry access not supported (not a Windows OS?)."))
						// TODO Auto-generated catch block
						e.printStackTrace();
				}
				return false;
			case MACOS:
			case LINUX:
				Vector<String> cmd = new Vector<String>();
				cmd.add("which");
				cmd.add("mono");
				Vector<String> res = null;
				try {
					res = QuickAppExecution.execute(cmd);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				if (res != null) {
					if (res.get(0).startsWith("/")
							&& res.get(0).endsWith("mono")) {
						return true;
					}
				}
				return false;
			default:
				return false;
		}
	}

	/**
	 * Export given dat-file to target folder
	 * 
	 * @param targetFolder
	 *            Target folder
	 * @param input
	 *            Dat file
	 */
	public static void export(File targetFolder, File input) {
		if (!targetFolder.exists())
			targetFolder.mkdir();

		Vector<String> cmdLine = getProgramInvocation();
		cmdLine.add("-export");
		cmdLine.add(targetFolder.getPath());
		cmdLine.add(input.getPath());
		// System.out.println(cmdLine.toString());
		Vector<String> res = null;
		try {
			res = QuickAppExecution.execute(cmdLine);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (res != null) {
			// check for errors
			System.out.println(res.toString());
		}
	}

	/**
	 * Import given folder to a .dat-file
	 * 
	 * @param sourceFolders
	 *            Folders containing .oni-files
	 * @param targetFile
	 *            Target .dat-file
	 */
	public static void importLevel(Vector<File> sourceFolders, File targetFile) {
		Vector<String> cmdLine = getProgramInvocation();
		cmdLine.add(getImportParam());
		for (File f : sourceFolders)
			cmdLine.add(f.getPath());
		cmdLine.add(targetFile.getPath());
		// System.out.println(cmdLine.toString());
		Vector<String> res = null;
		try {
			res = QuickAppExecution.execute(cmdLine);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (res != null) {
			// check for errors
			System.out.println(res.toString());
		}
	}

	/**
	 * Move files from one location to another using OniSplit so relations are
	 * handled
	 * 
	 * @param targetFolder
	 *            Target folder for files
	 * @param input
	 *            Files to move, can contain wildcards
	 * @param moveParameter
	 *            e.g. overwrite, delete
	 */
	public static void move(File targetFolder, String input,
			String moveParameter) {
		if (!targetFolder.exists())
			targetFolder.mkdir();

		Vector<String> cmdLine = getProgramInvocation();
		cmdLine.add("-move"
				+ (moveParameter != null ? ":" + moveParameter : ""));
		cmdLine.add(targetFolder.getPath());
		cmdLine.add(input);
		Vector<String> res = null;
		try {
			res = QuickAppExecution.execute(cmdLine);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if (res != null && res.size() > 0) {
			// TODO: errors
			System.out.println(res.toString());
		}
	}

	private static String getImportParam() {
		if (Settings.getPlatform() == Platform.MACOS)
			return "-import:sep";
		else
			return "-import:nosep";
	}

	private static Vector<String> getProgramInvocation() {
		Vector<String> res = new Vector<String>();
		if (Settings.getPlatform() != Platform.WIN)
			res.add("mono");
		res.add(new File(Paths.getInstallerPath(), "Onisplit.exe").getPath());
		return res;
	}
}
