package net.oni2.aeinstaller.backend.mods;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;

import net.oni2.aeinstaller.backend.Paths;
import net.oni2.aeinstaller.backend.depot.DepotManager;
import net.oni2.aeinstaller.backend.depot.model.NodeMod;
import net.oni2.aeinstaller.backend.depot.model.TaxonomyTerm;

/**
 * @author Christian Illy
 */
public class ModManager {
	// Download mods
	// Update mods

	private static ModManager instance = new ModManager();

	private HashMap<String, Type> types = new HashMap<String, Type>();
	private HashMap<Integer, Mod> mods = new HashMap<Integer, Mod>();

	/**
	 * First initialization of ModManager
	 */
	public void init() {
		types = new HashMap<String, Type>();
		mods = new HashMap<Integer, Mod>();

		types.put("-Local-", new Type("-Local-", null));

		for (TaxonomyTerm tt : DepotManager.getInstance()
				.getTaxonomyTermsByVocabulary(
						DepotManager.getInstance().getVocabIdType())) {
			types.put(tt.getName(), new Type(tt.getName(), tt));
		}

		HashMap<Integer, Mod> modFolders = new HashMap<Integer, Mod>();
		if (Paths.getModsPath().exists()) {
			for (File f : Paths.getModsPath().listFiles(new FileFilter() {
				@Override
				public boolean accept(File pathname) {
					return pathname.isDirectory();
				}
			})) {
				Mod m = new Mod(f);
				modFolders.put(m.getPackageNumber(), m);
			}
		}

		for (NodeMod nm : DepotManager.getInstance().getModPackageNodes()) {
			if (nm.getUploads().size() == 1) {
				Mod m = new Mod(nm);
				mods.put(m.getPackageNumber(), m);
				modFolders.remove(m.getPackageNumber());
			}
		}

		for (Mod m : modFolders.values()) {
			mods.put(m.getPackageNumber(), m);
		}
	}

	public void refreshLocalMods() {
		// TODO: evtl nur private e.g. als listener für downloads?
	}

	/**
	 * @return Singleton instance
	 */
	public static ModManager getInstance() {
		return instance;
	}

	Type getTypeByName(String name) {
		return types.get(name);
	}

	/**
	 * @return Collection of types which do have mods associated
	 */
	public Collection<Type> getTypesWithContent() {
		Vector<Type> res = new Vector<Type>();
		for (Type t : types.values()) {
			if (t.getEntries().size() > 0)
				res.add(t);
		}
		return res;
	}

	/**
	 * @return Collection of mods
	 */
	public Collection<Mod> getMods() {
		return mods.values();
	}

	/**
	 * @return Mods which are always installed
	 */
	public Collection<Mod> getDefaultMods() {
		Vector<Mod> res = new Vector<Mod>();
		for (Mod m : mods.values()) {
			if (m.isDefaultMod())
				res.add(m);
		}
		return res;
	}
}
