package net.oni2.aeinstaller.gui.modtable;

import javax.swing.RowFilter;

import net.oni2.aeinstaller.backend.mods.Mod;
import net.oni2.aeinstaller.backend.mods.Type;

/**
 * @author Christian Illy
 */
public class ModTableFilter extends RowFilter<ModTableModel, Integer> {
	Type type = null;

	/**
	 * @param type
	 *            Type of mods to show (null for all)
	 */
	public ModTableFilter(Type type) {
		super();
		this.type = type;
	}

	@Override
	public boolean include(
			RowFilter.Entry<? extends ModTableModel, ? extends Integer> entry) {
		Mod mod = (Mod) entry.getModel().getValueAt(entry.getIdentifier(), -1);

		if (mod.isDefaultMod())
			return false;

		if (!mod.validOnPlatform())
			return false;

		if (type == null)
			return true;

		return mod.getTypes().contains(type);
	}
}
