package net.oni2.aeinstaller.backend.mods;

import java.util.HashSet;

import net.oni2.aeinstaller.backend.depot.model.TaxonomyTerm;

/**
 * @author Christian Illy
 */
public class Type {
	String name;
	TaxonomyTerm depotTerm;

	HashSet<Mod> entries = new HashSet<Mod>();

	/**
	 * Create a new local type declaration
	 * 
	 * @param name
	 *            Name of type
	 * @param tt
	 *            Optional TaxTerm link
	 */
	public Type(String name, TaxonomyTerm tt) {
		this.name = name;
		this.depotTerm = tt;
	}

	void addEntry(Mod m) {
		entries.add(m);
	}

	/**
	 * @return Name of type
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return Entries for type
	 */
	public HashSet<Mod> getEntries() {
		return entries;
	}

	@Override
	public String toString() {
		return String.format("%s (%d)", name, entries.size());
	}
}
