package net.oni2.aeinstaller.backend;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;

/**
 * @author Christian Illy
 */
public class QuickAppExecution {

	/**
	 * Execute a short running application
	 * 
	 * @param cmdLine
	 *            List of command and arguments
	 * @return List of output lines
	 * @throws IOException
	 *             Exc
	 */
	public static Vector<String> execute(List<String> cmdLine)
			throws IOException {
		ProcessBuilder pb = new ProcessBuilder(cmdLine);
		pb.redirectErrorStream(true);
		Process proc = pb.start();

		InputStream is = proc.getInputStream();
		InputStreamReader isr = new InputStreamReader(is);
		BufferedReader br = new BufferedReader(isr);

		String line;
		Vector<String> lines = new Vector<String>();

		while ((line = br.readLine()) != null) {
			lines.add(line);
		}
		return lines;
	}

}
