package net.oni2.aeinstaller.backend.depot.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

import net.oni2.aeinstaller.backend.depot.DepotConfig;
import net.oni2.aeinstaller.backend.depot.DepotManager;
import net.oni2.aeinstaller.backend.mods.ECompatiblePlatform;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class NodeMod extends Node {
	private Vector<NodeField_Upload> uploads = new Vector<NodeField_Upload>();
	private HashMap<Integer, HashSet<Integer>> taxonomyTerms = new HashMap<Integer, HashSet<Integer>>();
	private HashMap<String, String> fields = new HashMap<String, String>();

	/**
	 * @param json
	 *            JSON object of Mod-node to parse
	 * @throws JSONException
	 *             On key not found / wrong type
	 */
	public NodeMod(JSONObject json) throws JSONException {
		super(json);

		Object uploadObj = json.get("upload");
		if (uploadObj instanceof JSONObject) {
			JSONArray jUploads = ((JSONObject) uploadObj).getJSONArray("und");
			for (int i = 0; i < jUploads.length(); i++) {
				NodeField_Upload up = new NodeField_Upload(
						jUploads.getJSONObject(i));
				if (up.getDisplay() != 0) {
					uploads.add(up);
				}
			}
		}

		for (Object key : json.keySet()) {
			String keyS = ((String) key).toLowerCase();
			Object val = json.get(keyS);
			if (keyS.startsWith("field_")) {
				String fName = keyS.substring(keyS.indexOf("_") + 1);
				String value = "";
				if (val instanceof JSONObject) {
					value = ((JSONObject) val).getJSONArray("und")
							.getJSONObject(0).getString("value");
				}
				fields.put(fName, value);
			}

			if (keyS.startsWith("taxonomy_vocabulary_")) {
				int vid = Integer
						.parseInt(keyS.substring(keyS.lastIndexOf("_") + 1));
				HashSet<Integer> values = new HashSet<Integer>();
				if (val instanceof JSONObject) {
					JSONArray ja = ((JSONObject) val).getJSONArray("und");
					for (int i = 0; i < ja.length(); i++) {
						values.add(ja.getJSONObject(i).getInt("tid"));
					}
				}
				taxonomyTerms.put(vid, values);
			}
		}
	}

	/**
	 * @return the uploads
	 */
	public Vector<NodeField_Upload> getUploads() {
		return uploads;
	}

	/**
	 * @return Types
	 */
	public HashSet<TaxonomyTerm> getTypes() {
		HashSet<TaxonomyTerm> tt = new HashSet<TaxonomyTerm>();
		for (int t : taxonomyTerms.get(DepotManager.getInstance()
				.getVocabIdType())) {
			tt.add(DepotManager.getInstance().getTaxonomyTerm(t));
		}
		return tt;
	}

	/**
	 * @return Install method
	 */
	public TaxonomyTerm getInstallMethod() {
		return DepotManager.getInstance().getTaxonomyTerm(
				taxonomyTerms
						.get(DepotManager.getInstance().getVocabIdInstMethod())
						.iterator().next());
	}

	/**
	 * @return Compatible platform
	 */
	public ECompatiblePlatform getPlatform() {
		TaxonomyTerm term = DepotManager.getInstance().getTaxonomyTerm(
				taxonomyTerms
						.get(DepotManager.getInstance().getVocabIdPlatform())
						.iterator().next());

		String validPlatform = term.getName();
		if (validPlatform.equalsIgnoreCase(DepotConfig
				.getTaxonomyName_Platform_Both()))
			return ECompatiblePlatform.BOTH;
		if (validPlatform.equalsIgnoreCase(DepotConfig
				.getTaxonomyName_Platform_Win()))
			return ECompatiblePlatform.WIN;
		if (validPlatform.equalsIgnoreCase(DepotConfig
				.getTaxonomyName_Platform_Mac()))
			return ECompatiblePlatform.MACOS;

		return null;
	}

	/**
	 * @return Creator of mod
	 */
	public String getCreator() {
		if (fields.get("creator") != null)
			return fields.get("creator");
		else
			return "";
	}

	/**
	 * @return Version of mod
	 */
	public String getVersion() {
		if (fields.get("version") != null)
			return fields.get("version");
		else
			return "";
	}

	/**
	 * @return Package number
	 */
	public int getPackageNumber() {
		return Integer.parseInt(fields.get("package_number"));
	}

	/**
	 * @return Is this mod a tool?
	 */
	public boolean isTool() {
		TaxonomyTerm tt = DepotManager.getInstance().getTaxonomyTerm(
				DepotConfig.getTaxonomyName_ModType_Tool());
		return getTypes().contains(tt);
	}
}
