package net.oni2.aeinstaller.backend.mods.download;

import net.oni2.aeinstaller.backend.mods.download.ModDownloader.State;

/**
 * @author Christian Illy
 */
public interface ModDownloaderListener {
	/**
	 * Callback for progress updates on mod downloads
	 * 
	 * @param source
	 *            Event source
	 * @param state
	 *            Current state
	 * @param filesDown
	 *            Downloaded(+unpacked) files
	 * @param filesTotal
	 *            Files in total to handle
	 * @param bytesDown
	 *            Bytes downloaded
	 * @param bytesTotal
	 *            Bytes in total to handle
	 */
	public void updateStatus(ModDownloader source, State state, int filesDown,
			int filesTotal, int bytesDown, int bytesTotal);
}
