/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Alerts;
import com.sun.net.ssl.internal.ssl.CipherBox;
import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.ClientHandshaker;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.EngineArgs;
import com.sun.net.ssl.internal.ssl.EngineInputRecord;
import com.sun.net.ssl.internal.ssl.EngineOutputRecord;
import com.sun.net.ssl.internal.ssl.EngineWriter;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.ServerHandshaker;
import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;

public final class SSLEngineImpl
extends SSLEngine {
    private int connectionState;
    private static final int cs_START = 0;
    private static final int cs_HANDSHAKE = 1;
    private static final int cs_DATA = 2;
    private static final int cs_RENEGOTIATE = 3;
    private static final int cs_ERROR = 4;
    private static final int cs_CLOSED = 6;
    private boolean inboundDone = false;
    EngineWriter writer;
    private SSLContextImpl sslContext;
    private SSLSessionImpl sess;
    private Handshaker handshaker;
    static final byte clauth_none = 0;
    static final byte clauth_requested = 1;
    static final byte clauth_required = 2;
    private boolean expectingFinished;
    private boolean recvCN;
    private SSLException closeReason;
    private byte doClientAuth;
    private CipherSuiteList enabledCipherSuites;
    private boolean enableSessionCreation = true;
    EngineInputRecord inputRecord;
    EngineOutputRecord outputRecord;
    private AccessControlContext acc;
    private String identificationAlg = null;
    private boolean serverModeSet = false;
    private boolean roleIsServer;
    private ProtocolList enabledProtocols;
    private ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private MAC readMAC;
    private MAC writeMAC;
    private CipherBox readCipher;
    private CipherBox writeCipher;
    private Object wrapLock;
    private Object unwrapLock;
    Object writeLock;
    private static final Debug debug = Debug.getInstance("ssl");

    SSLEngineImpl(SSLContextImpl sSLContextImpl) {
        this.init(sSLContextImpl);
    }

    SSLEngineImpl(SSLContextImpl sSLContextImpl, String string, int n) {
        super(string, n);
        this.init(sSLContextImpl);
    }

    private void init(SSLContextImpl sSLContextImpl) {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println("Using SSLEngineImpl.");
        }
        this.sslContext = sSLContextImpl;
        this.sess = SSLSessionImpl.nullSession;
        this.roleIsServer = true;
        this.connectionState = 0;
        this.readCipher = CipherBox.NULL;
        this.readMAC = MAC.NULL;
        this.writeCipher = CipherBox.NULL;
        this.writeMAC = MAC.NULL;
        this.enabledCipherSuites = CipherSuiteList.getDefault();
        this.enabledProtocols = ProtocolList.getDefault();
        this.wrapLock = new Object();
        this.unwrapLock = new Object();
        this.writeLock = new Object();
        this.acc = AccessController.getContext();
        this.outputRecord = new EngineOutputRecord(23, this);
        this.inputRecord = new EngineInputRecord(this);
        this.inputRecord.enableFormatChecks();
        this.writer = new EngineWriter();
    }

    private void initHandshaker() {
        switch (this.connectionState) {
            case 0: 
            case 2: {
                break;
            }
            case 1: 
            case 3: {
                return;
            }
            default: {
                throw new IllegalStateException("Internal error");
            }
        }
        this.connectionState = this.connectionState == 0 ? 1 : 3;
        this.handshaker = this.roleIsServer ? new ServerHandshaker(this, this.sslContext, this.enabledProtocols, this.doClientAuth, this.connectionState == 3, this.protocolVersion) : new ClientHandshaker(this, this.sslContext, this.enabledProtocols, this.protocolVersion);
        this.handshaker.enabledCipherSuites = this.enabledCipherSuites;
        this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        if (this.connectionState == 3) {
            this.handshaker.output.r.setHelloVersion(this.protocolVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult.HandshakeStatus getHSStatus(SSLEngineResult.HandshakeStatus handshakeStatus) {
        if (handshakeStatus != null) {
            return handshakeStatus;
        }
        SSLEngineImpl sSLEngineImpl = this;
        synchronized (sSLEngineImpl) {
            if (this.writer.hasOutboundData()) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (this.handshaker != null) {
                if (this.handshaker.taskOutstanding()) {
                    return SSLEngineResult.HandshakeStatus.NEED_TASK;
                }
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
            if (this.connectionState == 6 && !this.isInboundDone()) {
                return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
            return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
    }

    private synchronized void checkTaskThrown() throws SSLException {
        if (this.handshaker != null) {
            this.handshaker.checkThrown();
        }
    }

    private synchronized int getConnectionState() {
        return this.connectionState;
    }

    private synchronized void setConnectionState(int n) {
        this.connectionState = n;
    }

    AccessControlContext getAcc() {
        return this.acc;
    }

    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.getHSStatus(null);
    }

    private void changeReadCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        CipherBox cipherBox = this.readCipher;
        try {
            this.readCipher = this.handshaker.newReadCipher();
            this.readMAC = this.handshaker.newReadMAC();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLException)new SSLException("Algorithm missing:  ").initCause(generalSecurityException);
        }
        cipherBox.dispose();
    }

    void changeWriteCiphers() throws SSLException {
        if (this.connectionState != 1 && this.connectionState != 3) {
            throw new SSLProtocolException("State error, change cipher specs");
        }
        CipherBox cipherBox = this.writeCipher;
        try {
            this.writeCipher = this.handshaker.newWriteCipher();
            this.writeMAC = this.handshaker.newWriteMAC();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (SSLException)new SSLException("Algorithm missing:  ").initCause(generalSecurityException);
        }
        cipherBox.dispose();
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.outputRecord.setVersion(protocolVersion);
    }

    private synchronized void kickstartHandshake() throws IOException {
        switch (this.connectionState) {
            case 0: {
                if (!this.serverModeSet) {
                    throw new IllegalStateException("Client/Server mode not yet set.");
                }
                this.initHandshaker();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!Handshaker.renegotiable) {
                    throw new SSLHandshakeException("renegotiation is not allowed");
                }
                this.initHandshaker();
                break;
            }
            case 3: {
                return;
            }
            default: {
                throw new SSLException("SSLEngine is closing/closed");
            }
        }
        if (!this.handshaker.started()) {
            if (this.handshaker instanceof ClientHandshaker) {
                this.handshaker.kickstart();
            } else if (this.connectionState != 1) {
                this.handshaker.kickstart();
                this.handshaker.handshakeHash.reset();
            }
        }
    }

    public void beginHandshake() throws SSLException {
        try {
            this.kickstartHandshake();
        }
        catch (Exception exception) {
            this.fatal((byte)40, "Couldn't kickstart handshaking", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        EngineArgs engineArgs = new EngineArgs(byteBuffer, byteBufferArray, n, n2);
        try {
            Object object = this.unwrapLock;
            synchronized (object) {
                try {
                    SSLEngineResult sSLEngineResult = this.readNetRecord(engineArgs);
                    return sSLEngineResult;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception exception) {
                        this.fatal((byte)80, "problem unwrapping net record", exception);
                        SSLEngineResult sSLEngineResult = null;
                        return sSLEngineResult;
                    }
                }
            }
        }
        finally {
            engineArgs.resetLim();
        }
    }

    private SSLEngineResult readNetRecord(EngineArgs engineArgs) throws IOException {
        SSLEngineResult.Status status = null;
        SSLEngineResult.HandshakeStatus handshakeStatus = null;
        this.checkTaskThrown();
        if (this.isInboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHSStatus(null), 0, 0);
        }
        int n = this.getConnectionState();
        if (n == 1 || n == 0) {
            this.kickstartHandshake();
            handshakeStatus = this.getHSStatus(null);
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
            }
        }
        if (handshakeStatus == null) {
            handshakeStatus = this.getHSStatus(null);
        }
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
        }
        int n2 = this.inputRecord.bytesInCompletePacket(engineArgs.netData);
        if (n2 > this.sess.getPacketBufferSize()) {
            if (n2 > 33049) {
                throw new SSLProtocolException("Input SSL/TLS record too big: max = 33049 len = " + n2);
            }
            this.sess.expandBufferSizes();
        }
        if (n2 - 5 > engineArgs.getAppRemaining()) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, 0);
        }
        if (n2 == -1 || engineArgs.netData.remaining() < n2) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, handshakeStatus, 0, 0);
        }
        try {
            handshakeStatus = this.readRecord(engineArgs);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (IOException iOException) {
            SSLException sSLException = new SSLException("readRecord");
            sSLException.initCause(iOException);
            throw sSLException;
        }
        status = this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
        handshakeStatus = this.getHSStatus(handshakeStatus);
        return new SSLEngineResult(status, handshakeStatus, engineArgs.deltaNet(), engineArgs.deltaApp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult.HandshakeStatus readRecord(EngineArgs engineArgs) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus = null;
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = null;
        if (this.getConnectionState() != 4) {
            try {
                byteBuffer = this.inputRecord.read(engineArgs.netData);
            }
            catch (IOException iOException) {
                this.fatal((byte)10, iOException);
            }
            try {
                byteBuffer2 = this.inputRecord.decrypt(this.readCipher, byteBuffer);
            }
            catch (BadPaddingException badPaddingException) {
                byteBuffer.rewind();
                this.inputRecord.checkMAC(this.readMAC, byteBuffer);
                byte by = this.inputRecord.contentType() == 22 ? (byte)40 : 20;
                this.fatal(by, "Invalid padding", badPaddingException);
            }
            if (!this.inputRecord.checkMAC(this.readMAC, byteBuffer2)) {
                if (this.inputRecord.contentType() == 22) {
                    this.fatal((byte)40, "bad handshake record MAC");
                } else {
                    this.fatal((byte)20, "bad record MAC");
                }
            }
            SSLEngineImpl sSLEngineImpl = this;
            synchronized (sSLEngineImpl) {
                switch (this.inputRecord.contentType()) {
                    case 22: {
                        this.initHandshaker();
                        this.handshaker.process_record(this.inputRecord, this.expectingFinished);
                        this.expectingFinished = false;
                        if (this.handshaker.invalidated) {
                            this.handshaker = null;
                            if (this.connectionState != 3) break;
                            this.connectionState = 2;
                            break;
                        }
                        if (this.handshaker.isDone()) {
                            this.sess = this.handshaker.getSession();
                            if (!this.writer.hasOutboundData()) {
                                handshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
                            }
                            this.handshaker = null;
                            this.connectionState = 2;
                            break;
                        }
                        if (!this.handshaker.taskOutstanding()) break;
                        handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_TASK;
                        break;
                    }
                    case 23: {
                        if (this.connectionState != 2 && this.connectionState != 3 && this.connectionState != 6) {
                            throw new SSLProtocolException("Data received in non-data state: " + this.connectionState);
                        }
                        if (this.expectingFinished) {
                            throw new SSLProtocolException("Expecting finished message, received data");
                        }
                        if (this.inboundDone) break;
                        engineArgs.scatter(byteBuffer2.slice());
                        break;
                    }
                    case 21: {
                        this.recvAlert();
                        break;
                    }
                    case 20: {
                        if (this.connectionState != 1 && this.connectionState != 3 || this.inputRecord.available() != 1 || this.inputRecord.read() != 1) {
                            this.fatal((byte)10, "illegal change cipher spec msg, state = " + this.connectionState);
                        }
                        this.changeReadCiphers();
                        this.expectingFinished = true;
                        break;
                    }
                    default: {
                        if (debug == null || !Debug.isOn("ssl")) break;
                        System.out.println(SSLEngineImpl.threadName() + ", Received record type: " + this.inputRecord.contentType());
                    }
                }
            }
        }
        return handshakeStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        EngineArgs engineArgs = new EngineArgs(byteBufferArray, n, n2, byteBuffer);
        if (byteBuffer.remaining() < 16665) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHSStatus(null), 0, 0);
        }
        try {
            Object object = this.wrapLock;
            synchronized (object) {
                try {
                    SSLEngineResult sSLEngineResult = this.writeAppRecord(engineArgs);
                    return sSLEngineResult;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Exception exception) {
                        engineArgs.resetPos();
                        this.fatal((byte)80, "problem unwrapping net record", exception);
                        SSLEngineResult sSLEngineResult = null;
                        return sSLEngineResult;
                    }
                }
            }
        }
        finally {
            engineArgs.resetLim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult writeAppRecord(EngineArgs engineArgs) throws IOException {
        SSLEngineResult.Status status = null;
        SSLEngineResult.HandshakeStatus handshakeStatus = null;
        this.checkTaskThrown();
        if (this.writer.isOutboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHSStatus(null), 0, 0);
        }
        Object object = this;
        synchronized (object) {
            if (this.connectionState == 1 || this.connectionState == 0) {
                this.kickstartHandshake();
                handshakeStatus = this.getHSStatus(null);
                if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
                }
            }
        }
        if (handshakeStatus == null) {
            handshakeStatus = this.getHSStatus(null);
        }
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
        }
        try {
            object = this.writeLock;
            synchronized (object) {
                handshakeStatus = this.writeRecord(this.outputRecord, engineArgs);
            }
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (IOException iOException) {
            SSLException sSLException = new SSLException("Write problems");
            sSLException.initCause(iOException);
            throw sSLException;
        }
        status = this.isOutboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
        handshakeStatus = this.getHSStatus(handshakeStatus);
        return new SSLEngineResult(status, handshakeStatus, engineArgs.deltaApp(), engineArgs.deltaNet());
    }

    private SSLEngineResult.HandshakeStatus writeRecord(EngineOutputRecord engineOutputRecord, EngineArgs engineArgs) throws IOException {
        return this.writer.writeRecord(engineOutputRecord, engineArgs, this.writeMAC, this.writeCipher);
    }

    void writeRecord(EngineOutputRecord engineOutputRecord) throws IOException {
        this.writer.writeRecord(engineOutputRecord, this.writeMAC, this.writeCipher);
    }

    private void closeOutboundInternal() {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLEngineImpl.threadName() + ", closeOutboundInternal()");
        }
        if (this.writer.isOutboundDone()) {
            return;
        }
        switch (this.connectionState) {
            case 0: {
                this.writer.closeOutbound();
                this.inboundDone = true;
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            default: {
                this.warning((byte)0);
                this.writer.closeOutbound();
            }
        }
        this.writeCipher.dispose();
        this.connectionState = 6;
    }

    public synchronized void closeOutbound() {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLEngineImpl.threadName() + ", called closeOutbound()");
        }
        this.closeOutboundInternal();
    }

    public boolean isOutboundDone() {
        return this.writer.isOutboundDone();
    }

    private void closeInboundInternal() {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLEngineImpl.threadName() + ", closeInboundInternal()");
        }
        if (this.inboundDone) {
            return;
        }
        this.closeOutboundInternal();
        this.inboundDone = true;
        this.readCipher.dispose();
        this.connectionState = 6;
    }

    public synchronized void closeInbound() throws SSLException {
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLEngineImpl.threadName() + ", called closeInbound()");
        }
        if (this.connectionState != 0 && !this.recvCN) {
            this.recvCN = true;
            this.fatal((byte)80, "Inbound closed before receiving peer's close_notify: possible truncation attack?");
        } else {
            this.closeInboundInternal();
        }
    }

    public synchronized boolean isInboundDone() {
        return this.inboundDone;
    }

    public synchronized SSLSession getSession() {
        return this.sess;
    }

    public synchronized Runnable getDelegatedTask() {
        if (this.handshaker != null) {
            return this.handshaker.getTask();
        }
        return null;
    }

    void warning(byte by) {
        this.sendAlert((byte)1, by);
    }

    synchronized void fatal(byte by, String string) throws SSLException {
        this.fatal(by, string, null);
    }

    synchronized void fatal(byte by, Throwable throwable) throws SSLException {
        this.fatal(by, null, throwable);
    }

    synchronized void fatal(byte by, String string, Throwable throwable) throws SSLException {
        if (string == null) {
            string = "General SSLEngine problem";
        }
        if (throwable == null) {
            throwable = Alerts.getSSLException(by, throwable, string);
        }
        if (this.closeReason != null) {
            if (debug != null && Debug.isOn("ssl")) {
                System.out.println(SSLEngineImpl.threadName() + ", fatal: engine already closed.  Rethrowing " + throwable.toString());
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof SSLException) {
                throw (SSLException)throwable;
            }
            if (throwable instanceof Exception) {
                SSLException sSLException = new SSLException("fatal SSLEngine condition");
                sSLException.initCause(throwable);
                throw sSLException;
            }
        }
        if (debug != null && Debug.isOn("ssl")) {
            System.out.println(SSLEngineImpl.threadName() + ", fatal error: " + by + ": " + string + "\n" + throwable.toString());
        }
        int n = this.connectionState;
        this.connectionState = 4;
        this.inboundDone = true;
        this.sess.invalidate();
        if (n != 0) {
            this.sendAlert((byte)2, by);
        }
        this.closeReason = throwable instanceof SSLException ? (SSLException)throwable : Alerts.getSSLException(by, throwable, string);
        this.writer.closeOutbound();
        this.connectionState = 6;
        this.readCipher.dispose();
        this.writeCipher.dispose();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw this.closeReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recvAlert() throws IOException {
        Object object;
        byte by = (byte)this.inputRecord.read();
        byte by2 = (byte)this.inputRecord.read();
        if (by2 == -1) {
            this.fatal((byte)47, "Short alert message");
        }
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake"))) {
            object = System.out;
            synchronized (object) {
                System.out.print(SSLEngineImpl.threadName());
                System.out.print(", RECV " + this.protocolVersion + " ALERT:  ");
                if (by == 2) {
                    System.out.print("fatal, ");
                } else if (by == 1) {
                    System.out.print("warning, ");
                } else {
                    System.out.print("<level " + (0xFF & by) + ">, ");
                }
                System.out.println(Alerts.alertDescription(by2));
            }
        }
        if (by == 1) {
            if (by2 == 0) {
                if (this.connectionState == 1) {
                    this.fatal((byte)10, "Received close_notify during handshake");
                } else {
                    this.recvCN = true;
                    this.closeInboundInternal();
                }
            } else if (this.handshaker != null) {
                this.handshaker.handshakeAlert(by2);
            }
        } else {
            object = "Received fatal alert: " + Alerts.alertDescription(by2);
            if (this.closeReason == null) {
                this.closeReason = Alerts.getSSLException(by2, (String)object);
            }
            this.fatal((byte)10, (String)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAlert(byte by, byte by2) {
        block11: {
            boolean bl;
            if (this.connectionState >= 6) {
                return;
            }
            EngineOutputRecord engineOutputRecord = new EngineOutputRecord(21, this);
            engineOutputRecord.setVersion(this.protocolVersion);
            boolean bl2 = bl = debug != null && Debug.isOn("ssl");
            if (bl) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    System.out.print(SSLEngineImpl.threadName());
                    System.out.print(", SEND " + this.protocolVersion + " ALERT:  ");
                    if (by == 2) {
                        System.out.print("fatal, ");
                    } else if (by == 1) {
                        System.out.print("warning, ");
                    } else {
                        System.out.print("<level = " + (0xFF & by) + ">, ");
                    }
                    System.out.println("description = " + Alerts.alertDescription(by2));
                }
            }
            engineOutputRecord.write(by);
            engineOutputRecord.write(by2);
            try {
                this.writeRecord(engineOutputRecord);
            }
            catch (IOException iOException) {
                if (!bl) break block11;
                System.out.println(SSLEngineImpl.threadName() + ", Exception sending alert: " + iOException);
            }
        }
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setEnableSessionCreation(this.enableSessionCreation);
        }
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.doClientAuth = (byte)(bl ? 2 : 0);
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.started()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    public synchronized boolean getNeedClientAuth() {
        return this.doClientAuth == 2;
    }

    public synchronized void setWantClientAuth(boolean bl) {
        byte by = this.doClientAuth = bl ? (byte)1 : 0;
        if (this.handshaker != null && this.handshaker instanceof ServerHandshaker && !this.handshaker.started()) {
            ((ServerHandshaker)this.handshaker).setClientAuth(this.doClientAuth);
        }
    }

    public synchronized boolean getWantClientAuth() {
        return this.doClientAuth == 1;
    }

    public synchronized void setUseClientMode(boolean bl) {
        switch (this.connectionState) {
            case 0: {
                this.roleIsServer = !bl;
                this.serverModeSet = true;
                break;
            }
            case 1: {
                assert (this.handshaker != null);
                if (!this.handshaker.started()) {
                    this.roleIsServer = !bl;
                    this.connectionState = 0;
                    this.initHandshaker();
                    break;
                }
            }
            default: {
                if (debug != null && Debug.isOn("ssl")) {
                    System.out.println(SSLEngineImpl.threadName() + ", setUseClientMode() invoked in state = " + this.connectionState);
                }
                throw new IllegalArgumentException("Cannot change mode after SSL traffic has started");
            }
        }
    }

    public synchronized boolean getUseClientMode() {
        return !this.roleIsServer;
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList.clearAvailableCache();
        return CipherSuiteList.getSupported().toStringArray();
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = new CipherSuiteList(stringArray);
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.enabledCipherSuites = this.enabledCipherSuites;
        }
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites.toStringArray();
    }

    public String[] getSupportedProtocols() {
        return ProtocolList.getSupported().toStringArray();
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.enabledProtocols = new ProtocolList(stringArray);
        if (this.handshaker != null && !this.handshaker.started()) {
            this.handshaker.setEnabledProtocols(this.enabledProtocols);
        }
    }

    public synchronized String[] getEnabledProtocols() {
        return this.enabledProtocols.toStringArray();
    }

    public synchronized boolean trySetHostnameVerification(String string) {
        if (this.sslContext.getX509TrustManager() instanceof X509ExtendedTrustManager) {
            this.identificationAlg = string;
            return true;
        }
        return false;
    }

    public synchronized String getHostnameVerification() {
        return this.identificationAlg;
    }

    private static String threadName() {
        return Thread.currentThread().getName();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[");
        stringBuilder.append("SSLEngine[hostname=");
        String string = this.getPeerHost();
        stringBuilder.append(string == null ? "null" : string);
        stringBuilder.append(" port=");
        stringBuilder.append(Integer.toString(this.getPeerPort()));
        stringBuilder.append("] ");
        stringBuilder.append(this.getSession().getCipherSuite());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

