/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.TraceListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;

public final class FileTraceListener
implements TraceListener {
    private File logFile;
    private PrintStream fileTraceStream;
    private boolean append;

    public FileTraceListener(File file, boolean bl) {
        this.append = bl;
        this.logFile = file;
        this.init();
    }

    private void init() {
        try {
            this.fileTraceStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile.getPath(), this.append)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void print(String string) {
        try {
            if (this.logFile.length() >= (long)(Config.getIntProperty("deployment.max.output.file.size") * 0x100000)) {
                int n;
                this.fileTraceStream.close();
                File file = File.createTempFile("javaws", ".temp", this.logFile.getParentFile());
                long l = this.logFile.length() / 4L;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedReader.skip(l * 3L);
                while ((n = bufferedReader.read()) != -1) {
                    bufferedWriter.write(n);
                }
                bufferedReader.close();
                bufferedWriter.close();
                if (this.logFile.delete()) {
                    file.renameTo(this.logFile);
                    this.init();
                }
            }
            this.fileTraceStream.print(string);
            this.fileTraceStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

