/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationAlreadyRegisteredException;
import com.sun.deploy.association.AssociationNotRegisteredException;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppUtility;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.WinRegistry;
import com.sun.javaws.IcoEncoder;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.WinBrowserSupport;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;

public class WinInstallHandler
extends LocalInstallHandler {
    private static final String INSTALLED_DESKTOP_SHORTCUT_KEY = "installed.desktop";
    private static final String INSTALLED_START_MENU_KEY = "installed.menu";
    private static final String UNINSTALLED_START_MENU_KEY = "installed.uninstalled";
    private static final String RCONTENT_START_MENU_KEY = "installed.rc";
    public static final int TYPE_DESKTOP = 1;
    public static final int TYPE_START_MENU = 2;
    private static final String REG_SHORTCUT_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    private static final String REG_DESKTOP_PATH_KEY = "Desktop";
    private static final String REG_START_MENU_PATH_KEY = "Programs";
    private static final int MAX_PATH = 260;
    private static final String SHORTCUT_EXTENSION = ".lnk";
    private static final int MAX_SHORTCUT = 260 - (".lnk".length() + 1);
    private boolean _loadedPaths = false;
    private String _desktopPath;
    private String _startMenuPath;
    private static boolean useSystem;
    private final String nameBadChars = "\"\\/|:?*<>";
    private final String dirBadChars = "\"|:?*<>";
    private static final char[] WHITESPACE_PAD;
    private static final String ELLIPSIS = "...";
    private static final int MAX_INSTALL_DESCRIPTION_LENGTH = 80;

    public boolean isShortcutExists(LocalApplicationProperties localApplicationProperties) {
        String string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        String string2 = localApplicationProperties.get(INSTALLED_START_MENU_KEY);
        boolean bl = false;
        boolean bl2 = false;
        if (string != null) {
            bl = new File(string).exists();
        }
        if (string2 != null) {
            bl2 = new File(string2).exists();
        }
        if (string != null && string2 != null) {
            return bl && bl2;
        }
        return bl || bl2;
    }

    public boolean[] whichShortcutsExist(LocalApplicationProperties localApplicationProperties) {
        boolean[] blArray = new boolean[2];
        String string = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY);
        blArray[0] = string != null && new File(string).exists();
        String string2 = localApplicationProperties.get(INSTALLED_START_MENU_KEY);
        blArray[1] = string2 != null && new File(string2).exists();
        return blArray;
    }

    public String getDefaultIconPath() {
        return Config.getInstance().getSystemJavawsPath();
    }

    public String getAssociationOpenCommand(String string) {
        return "\"" + Config.getJavawsCommand() + "\"" + " \"-open\" \"%1\" " + "\"" + string + "\"";
    }

    public String getAssociationPrintCommand(String string) {
        return "\"" + Config.getJavawsCommand() + "\"" + " \"-print\" \"%1\" " + "\"" + string + "\"";
    }

    public void registerAssociationInternal(Association association) throws AssociationAlreadyRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService();
        if (Environment.isSystemCacheMode() || useSystem) {
            associationService.registerSystemAssociation(association);
        } else {
            associationService.registerUserAssociation(association);
        }
    }

    public void unregisterAssociationInternal(Association association) throws AssociationNotRegisteredException, RegisterFailedException {
        AssociationService associationService = new AssociationService();
        if (Environment.isSystemCacheMode() || useSystem) {
            associationService.unregisterSystemAssociation(association);
        } else {
            associationService.unregisterUserAssociation(association);
        }
    }

    public boolean hasAssociation(Association association) {
        AssociationService associationService = new AssociationService();
        return associationService.hasAssociation(association);
    }

    public boolean isLocalInstallSupported() {
        return true;
    }

    public boolean isAssociationSupported() {
        return true;
    }

    boolean isAssociationFileExtSupported(String string) {
        if (string == null) {
            return false;
        }
        String string2 = AppUtility.removeDotFromFileExtension((String)string.toLowerCase());
        return !string2.equals("exe") && !string2.equals("com") && !string2.equals("bat");
    }

    public boolean removePathShortcut(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    protected boolean removeShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        String string;
        if (localApplicationProperties == null) {
            Trace.println((String)"No LAP for uninstall, bailing!", (TraceLevel)TraceLevel.TEMP);
            return false;
        }
        String string2 = null;
        boolean bl2 = false;
        String string3 = localApplicationProperties.get(INSTALLED_START_MENU_KEY);
        if (string3 != null) {
            if (!this.deleteShortcut(string3)) {
                bl2 = true;
            } else {
                localApplicationProperties.put(INSTALLED_START_MENU_KEY, null);
            }
            string2 = string3;
        }
        if ((string3 = localApplicationProperties.get(UNINSTALLED_START_MENU_KEY)) != null) {
            if (!this.deleteShortcut(string3)) {
                bl2 = true;
            } else {
                localApplicationProperties.put(UNINSTALLED_START_MENU_KEY, null);
            }
            string2 = string3;
        }
        if ((string = localApplicationProperties.get(RCONTENT_START_MENU_KEY)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreElements()) {
                string3 = stringTokenizer.nextToken();
                if (string3 == null) continue;
                if (!this.deleteShortcut(string3)) {
                    bl2 = true;
                }
                string2 = string3;
            }
            localApplicationProperties.put(RCONTENT_START_MENU_KEY, null);
        }
        if (string2 != null) {
            this.checkEmpty(string2);
        }
        if (bl && (string3 = localApplicationProperties.get(INSTALLED_DESKTOP_SHORTCUT_KEY)) != null) {
            if (!this.deleteShortcut(string3)) {
                bl2 = true;
            } else {
                localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, null);
            }
        }
        if (bl2) {
            Trace.println((String)"uninstall shortcut failed", (TraceLevel)TraceLevel.TEMP);
        }
        localApplicationProperties.setLocallyInstalled(false);
        WinInstallHandler.save(localApplicationProperties);
        return !bl2;
    }

    private void checkEmpty(String string) {
        try {
            for (File file = new File(string).getParentFile(); file != null && file.isDirectory() && file.list().length == 0; file = file.getParentFile()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean hasValidTitle(LaunchDesc launchDesc) {
        if (launchDesc == null) {
            return false;
        }
        InformationDesc informationDesc = launchDesc.getInformation();
        if (informationDesc == null || this.nameFilter(informationDesc.getTitle()) == null) {
            Trace.println((String)"Invalid: No title!", (TraceLevel)TraceLevel.TEMP);
            return false;
        }
        return true;
    }

    protected boolean createShortcuts(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean[] blArray) {
        boolean bl;
        if (!this.hasValidTitle(launchDesc)) {
            return false;
        }
        if (this.isShortcutExists(localApplicationProperties) && !WinInstallHandler.shouldInstallOverExisting(launchDesc)) {
            return false;
        }
        String string = null;
        File file = null;
        try {
            file = DownloadEngine.getCachedFile((URL)launchDesc.getCanonicalHome());
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
        if (file != null) {
            string = file.getPath();
        }
        if (string == null) {
            this.installFailed(launchDesc);
            return false;
        }
        ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
        boolean bl2 = shortcutDesc == null ? true : shortcutDesc.getDesktop();
        boolean bl3 = bl = shortcutDesc == null ? true : shortcutDesc.getMenu();
        if (blArray != null) {
            bl2 = bl2 && blArray[0];
            boolean bl4 = bl = bl && blArray[1];
        }
        if (bl2 && !this.handleInstall(launchDesc, shortcutDesc, localApplicationProperties, string, 1)) {
            this.installFailed(launchDesc);
            return false;
        }
        if (bl && !this.handleInstall(launchDesc, shortcutDesc, localApplicationProperties, string, 2)) {
            this.removeShortcuts(launchDesc, localApplicationProperties, bl2);
            this.installFailed(launchDesc);
            return false;
        }
        if (bl || bl2) {
            localApplicationProperties.setLocallyInstalled(true);
            WinInstallHandler.save(localApplicationProperties);
        }
        return true;
    }

    protected void registerWithInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        Config config = Config.getInstance();
        InformationDesc informationDesc = launchDesc.getInformation();
        String string = config.toExecArg(launchDesc.getCanonicalHome().toString());
        String string2 = this.nameFilter(informationDesc.getTitle());
        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
            String string3 = this.getIconPath(launchDesc, false);
            String string4 = informationDesc.getVendor();
            String string5 = this.getBestFitDescription(informationDesc);
            URL uRL = informationDesc.getHome();
            String string6 = null;
            boolean bl = Environment.isSystemCacheMode();
            if (uRL != null) {
                string6 = informationDesc.getHome().toExternalForm();
            }
            if (string4 == null) {
                string4 = string6;
            }
            if (string4 == null && string5.trim().length() == 0) {
                string4 = null;
                string5 = null;
                string6 = null;
            }
            localApplicationProperties.setRegisteredTitle(string2);
            config.addRemoveProgramsAdd(string, string2, string3, string4, string5, string6, bl);
        }
    }

    protected void removeFromInstallPanel(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties) {
        Config config = Config.getInstance();
        boolean bl = Environment.isSystemCacheMode();
        String string = localApplicationProperties.getRegisteredTitle();
        if (string != null && string.length() != 0) {
            config.addRemoveProgramsRemove(string, bl);
        }
    }

    private String getBestFitDescription(InformationDesc informationDesc) {
        String string = null;
        string = informationDesc.getDescription(2);
        if (string == null && (string = informationDesc.getDescription(0)) == null && (string = informationDesc.getDescription(1)) == null) {
            string = informationDesc.getDescription(3);
        }
        if (string != null) {
            int n = string.length();
            if (n < WHITESPACE_PAD.length) {
                string = new StringBuffer(string).append(WHITESPACE_PAD, 0, WHITESPACE_PAD.length - n).toString();
            } else if (n > 80) {
                int n2 = ELLIPSIS.length();
                string = new StringBuffer(string).delete(80 - n2, n).append(ELLIPSIS).toString();
            }
        } else {
            string = new String(WHITESPACE_PAD);
        }
        return string;
    }

    private void installFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            public void run() {
                UIFactory.showErrorDialog(null, (String)ResourceManager.getString((String)"install.installFailed", (String)WinInstallHandler.this.getInstallName(launchDesc)), (String)ResourceManager.getString((String)"install.installFailedTitle"));
            }
        };
        WinInstallHandler.invokeRunnable(runnable);
    }

    private void uninstallFailed(final LaunchDesc launchDesc) {
        Runnable runnable = new Runnable(){

            public void run() {
                UIFactory.showErrorDialog(null, (String)ResourceManager.getString((String)"install.uninstallFailed", (String)WinInstallHandler.this.getInstallName(launchDesc)), (String)ResourceManager.getString((String)"install.uninstallFailedTitle"));
            }
        };
        WinInstallHandler.invokeRunnable(runnable);
    }

    private boolean handleInstall(LaunchDesc launchDesc, ShortcutDesc shortcutDesc, LocalApplicationProperties localApplicationProperties, String string, int n) {
        InformationDesc informationDesc = launchDesc.getInformation();
        String string2 = null;
        String string3 = null;
        String string4 = this.getIconPath(launchDesc, true);
        String string5 = this.getIconPath(launchDesc, false);
        String string6 = Config.getInstance().getSystemJavawsPath();
        String string7 = informationDesc.getDescription(0);
        String string8 = informationDesc.getDescription(3);
        String string9 = string8 == null ? string7 : string8;
        boolean bl = true;
        boolean bl2 = !informationDesc.supportsOfflineOperation() || shortcutDesc == null || shortcutDesc.getOnline();
        String string10 = bl2 ? "" : "-offline ";
        String string11 = "-localfile " + string10 + "\"" + string + "\"";
        int n2 = 0;
        if (n == 1) {
            string2 = this.getDesktopPath(launchDesc);
            n2 = this.installWrapper(string2, string3 = this.getInstallName(launchDesc), string9, string6, string11, null, string4);
            if (n2 == 0) {
                localApplicationProperties.put(INSTALLED_DESKTOP_SHORTCUT_KEY, string2);
                Trace.println((String)("Installed desktop shortcut for: " + string3 + "."), (TraceLevel)TraceLevel.TEMP);
            } else {
                bl = false;
                Trace.println((String)("Installed desktop shortcut for: " + string3 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
            }
        } else {
            File file = new File(this.getSubMenuPath(launchDesc));
            if (file.exists() || file.mkdirs()) {
                string2 = this.getStartMenuPath(launchDesc);
                n2 = this.installWrapper(string2, string3 = this.getInstallName(launchDesc), string9, string6, string11, null, string5);
                if (n2 == 0) {
                    localApplicationProperties.put(INSTALLED_START_MENU_KEY, string2);
                    Trace.println((String)("Installed menu shortcut for: " + string3 + "."), (TraceLevel)TraceLevel.TEMP);
                } else {
                    bl = false;
                    Trace.println((String)("Installed menu shortcut for: " + string3 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                }
                String string12 = this.getSubMenuDir(launchDesc);
                if ((string12 == null || !string12.equals("Startup")) && this.addUninstallShortcut()) {
                    string11 = "-uninstall \"" + string + "\"";
                    string2 = this.getUninstallPath(launchDesc);
                    n2 = this.installWrapper(string2, string3 = this.getUninstallMenuName(launchDesc), string9, string6, string11, null, string5);
                    if (n2 == 0) {
                        localApplicationProperties.put(UNINSTALLED_START_MENU_KEY, string2);
                        Trace.println((String)("Installed menu shortcut for: " + string3 + "."), (TraceLevel)TraceLevel.TEMP);
                    } else {
                        bl = false;
                        Trace.println((String)("Installed menu shortcut for: " + string3 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                    }
                }
                RContentDesc[] rContentDescArray = informationDesc.getRelatedContent();
                StringBuffer stringBuffer = new StringBuffer(260 * rContentDescArray.length);
                if (rContentDescArray != null) {
                    for (int i = 0; i < rContentDescArray.length; ++i) {
                        string3 = this.nameFilter(rContentDescArray[i].getTitle());
                        URL uRL = rContentDescArray[i].getHref();
                        if (uRL.toString().endsWith("jnlp")) continue;
                        string9 = rContentDescArray[i].getDescription();
                        URL uRL2 = rContentDescArray[i].getIcon();
                        String string13 = null;
                        if (uRL2 != null) {
                            string13 = IcoEncoder.getIconPath(uRL2, null);
                        }
                        if (string13 == null) {
                            string13 = string4;
                        }
                        string2 = this.getRCPath(launchDesc, string3);
                        File file2 = null;
                        try {
                            file2 = DownloadEngine.getCachedFileNative((URL)uRL);
                        }
                        catch (IOException iOException) {
                            Trace.ignoredException((Exception)iOException);
                        }
                        string6 = new WinBrowserSupport().getDefaultHandler(uRL);
                        if (file2 != null) {
                            string11 = "\"file:" + file2.getAbsolutePath() + "\"";
                            n2 = this.installWrapper(string2, string3, string9, string6, string11, null, string13);
                            if (n2 == 0) {
                                stringBuffer.append(string2);
                                stringBuffer.append(File.pathSeparator);
                                Trace.println((String)("Installed menu shortcut for: " + string3 + "."), (TraceLevel)TraceLevel.TEMP);
                                continue;
                            }
                            bl = false;
                            Trace.println((String)("Installed menu shortcut for: " + string3 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                            continue;
                        }
                        string11 = uRL.toString();
                        n2 = this.installWrapper(string2, string3, string9, string6, string11, null, string13);
                        if (n2 == 0) {
                            stringBuffer.append(string2);
                            stringBuffer.append(File.pathSeparator);
                            Trace.println((String)("Installed menu shortcut for: " + string3 + "."), (TraceLevel)TraceLevel.TEMP);
                            continue;
                        }
                        bl = false;
                        Trace.println((String)("Installed menu shortcut for: " + string3 + " failed (" + n2 + ")!!!"), (TraceLevel)TraceLevel.TEMP);
                    }
                }
                if (stringBuffer.length() > 0) {
                    localApplicationProperties.put(RCONTENT_START_MENU_KEY, stringBuffer.toString());
                } else {
                    localApplicationProperties.put(RCONTENT_START_MENU_KEY, null);
                }
            } else {
                bl = false;
                Trace.println((String)("Installed menu shortcut for: " + string3 + " failed (can't create directory \"" + file.getAbsolutePath() + "\")!!!"), (TraceLevel)TraceLevel.TEMP);
            }
        }
        return bl;
    }

    private String getInstallName(LaunchDesc launchDesc) {
        return this.nameFilter(launchDesc.getInformation().getTitle());
    }

    private String getUninstallMenuName(LaunchDesc launchDesc) {
        String string = ResourceManager.getString((String)"install.startMenuUninstallShortcutName", (String)this.getInstallName(launchDesc));
        return string;
    }

    private String getDesktopPath(LaunchDesc launchDesc) {
        return this.getShortcutPath(this.getDesktopPath(), this.getInstallName(launchDesc));
    }

    private String getStartMenuPath(LaunchDesc launchDesc) {
        return this.getShortcutPath(this.getSubMenuPath(launchDesc), this.getInstallName(launchDesc));
    }

    private String getRCPath(LaunchDesc launchDesc, String string) {
        return this.getShortcutPath(this.getSubMenuPath(launchDesc), string);
    }

    private String getUninstallPath(LaunchDesc launchDesc) {
        return this.getShortcutPath(this.getSubMenuPath(launchDesc), this.getUninstallMenuName(launchDesc));
    }

    private String getSubMenuPath(LaunchDesc launchDesc) {
        String string;
        String string2 = this.getStartMenuPath();
        if (string2 != null && (string = this.getSubMenuDir(launchDesc)) != null) {
            string2 = string2 + string + File.separator;
        }
        return string2;
    }

    private String getSubMenuDir(LaunchDesc launchDesc) {
        String string;
        String string2 = this.getInstallName(launchDesc);
        ShortcutDesc shortcutDesc = launchDesc.getInformation().getShortcut();
        if (shortcutDesc != null && (string = shortcutDesc.getSubmenu()) != null) {
            string2 = this.dirFilter(string);
        }
        if (string2 != null && string2.equalsIgnoreCase("startup")) {
            string2 = "Startup";
        }
        return string2;
    }

    private String getDesktopPath() {
        this.loadPathsIfNecessary();
        return this._desktopPath;
    }

    private String getStartMenuPath() {
        this.loadPathsIfNecessary();
        return this._startMenuPath;
    }

    private void loadPathsIfNecessary() {
        int n = -2147483647;
        String string = "";
        if (Environment.isSystemCacheMode()) {
            n = -2147483646;
            string = "Common ";
        }
        if (!this._loadedPaths) {
            this._desktopPath = WinRegistry.getString((int)n, (String)REG_SHORTCUT_PATH, (String)(string + REG_DESKTOP_PATH_KEY));
            if (this._desktopPath != null && this._desktopPath.length() > 0 && this._desktopPath.charAt(this._desktopPath.length() - 1) != '\\') {
                this._desktopPath = this._desktopPath + '\\';
            }
            this._startMenuPath = WinRegistry.getString((int)n, (String)REG_SHORTCUT_PATH, (String)(string + REG_START_MENU_PATH_KEY));
            if (this._startMenuPath != null && this._startMenuPath.length() > 0 && this._startMenuPath.charAt(this._startMenuPath.length() - 1) != '\\') {
                this._startMenuPath = this._startMenuPath + '\\';
            }
            this._loadedPaths = true;
            Trace.println((String)("Start path: " + this._startMenuPath + " desktop " + this._desktopPath), (TraceLevel)TraceLevel.TEMP);
        }
    }

    private String nameFilter(String string) {
        return this.Filter(string, "\"\\/|:?*<>", '-');
    }

    private String dirFilter(String string) {
        String string2 = this.Filter(string, "\"|:?*<>", '-');
        return this.Filter(string2, "\\/", File.separatorChar);
    }

    private String Filter(String string, String string2, char c) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("nul")) {
            return "-nul-";
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (string2.indexOf(c2) >= 0) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private boolean deleteShortcut(String string) {
        File file = new File(string);
        if (file.exists()) {
            boolean bl = file.delete();
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                Trace.ignoredException((Exception)interruptedException);
            }
            return bl;
        }
        return true;
    }

    private String getIconPath(LaunchDesc launchDesc, boolean bl) {
        String string;
        String string2 = this.getDefaultIconPath();
        if (launchDesc != null && (string = IcoEncoder.getIconPath(launchDesc, bl)) != null) {
            string2 = string;
        }
        return string2;
    }

    private String getShortcutPath(String string, String string2) {
        String string3 = null;
        if (string != null && string.length() < MAX_SHORTCUT - 1 && string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(324);
            stringBuffer.append(string).append(string2);
            if (stringBuffer.length() > MAX_SHORTCUT) {
                stringBuffer.delete(MAX_SHORTCUT, stringBuffer.length());
            }
            stringBuffer.append(SHORTCUT_EXTENSION);
            string3 = stringBuffer.toString();
        }
        return string3;
    }

    private int installWrapper(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        Trace.println((String)"installshortcut with args:", (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    path: " + string), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    name: " + string2), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    desc: " + string3), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    appP: " + string4), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    args: " + string5), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    dir : " + string6), (TraceLevel)TraceLevel.TEMP);
        Trace.println((String)("    icon: " + string7), (TraceLevel)TraceLevel.TEMP);
        Trace.flush();
        return Config.getInstance().installShortcut(string, string2, string3, string4, string5, string6, string7);
    }

    static {
        String string = System.getProperty("os.name");
        useSystem = string.indexOf("2000") == -1 && string.indexOf("XP") == -1 && !Config.getInstance().isPlatformWindowsVista();
        WHITESPACE_PAD = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    }
}

