package net.oni2.aeinstaller.backend.depot;

import net.oni2.aeinstaller.backend.Settings;

/**
 * @author Christian Illy
 */
public class DepotConfig {

	/**
	 * @return Type-value of nodes which contain Mods
	 */
	public static String getNodeType_Mod() {
		return "mod";
	}

	/**
	 * @return Vocabulary name for platform field
	 */
	public static String getVocabularyName_Platform() {
		return "Platform";
	}

	/**
	 * @return Vocabulary name for installtype field
	 */
	public static String getVocabularyName_InstallType() {
		return "Install method";
	}

	/**
	 * @return Vocabulary name for modtype field
	 */
	public static String getVocabularyName_ModType() {
		return "Mod type";
	}

	/**
	 * @return Taxonomy term name for platform value Win
	 */
	public static String getTaxonomyName_Platform_Win() {
		return "Windows";
	}

	/**
	 * @return Taxonomy term name for platform value Mac
	 */
	public static String getTaxonomyName_Platform_Mac() {
		return "Mac OS";
	}

	/**
	 * @return Taxonomy term name for platform value Both
	 */
	public static String getTaxonomyName_Platform_Both() {
		return "Both";
	}

	/**
	 * @return Taxonomy term name for installtype Package
	 */
	public static String getTaxonomyName_InstallType_Package() {
		return "Package";
	}

	/**
	 * @return Taxonomy term name for modtype Tool
	 */
	public static String getTaxonomyName_ModType_Tool() {
		return "Tool";
	}

	/**
	 * @return First package number that's not a mandatory tool/mod. Everything
	 *         below is considered mandatory
	 */
	public static int getMandatoryLimit() {
		return 8000;
	}

	/**
	 * @return URL of Depot
	 */
	public static String getDepotUrl() {
		return Settings.getInstance().get("depot_url", "http://mods.oni2.net/");
	}

	/**
	 * @return URL of Depot API
	 */
	public static String getDepotApiUrl() {
		return Settings.getInstance().get("depot_api_url",
				"http://mods.oni2.net/?q=api/");
	}
}
