package net.oni2.aeinstaller.backend;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;

/**
 * @author Christian Illy
 */
public class AppExecution {

	/**
	 * Execute a short running application and wait for termination
	 * 
	 * @param cmdLine
	 *            List of command and arguments
	 * @return List of output lines
	 * @throws IOException
	 *             Exc
	 */
	public static Vector<String> executeAndWait(List<String> cmdLine)
			throws IOException {
		ProcessBuilder pb = new ProcessBuilder(cmdLine);
		pb.redirectErrorStream(true);
		Process proc = pb.start();

		InputStream is = proc.getInputStream();
		InputStreamReader isr = new InputStreamReader(is);
		BufferedReader br = new BufferedReader(isr);

		String line;
		Vector<String> lines = new Vector<String>();

		while ((line = br.readLine()) != null) {
			lines.add(line);
		}
		return lines;
	}

	/**
	 * Execute an app without waiting
	 * 
	 * @param cmd
	 *            Command and parameters
	 * @param workingDirectory
	 *            Working directory of app
	 */
	public static void execute(List<String> cmd, File workingDirectory) {
		try {
			ProcessBuilder pb = new ProcessBuilder(cmd);
			pb.directory(workingDirectory);
			pb.start();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
