#define AppId "{{B67333BB-1CF9-4EFD-A40B-E25B5CB4C8A7}}"
#define AppVersion "0.81"
#define AppLongName "Anniversary Edition of Oni"
#define AppShortName "AEInstaller"

#define MinJavaVersion "1.6"

[Setup]
AppId={#AppId}
AppVersion={#AppVersion}
AppName={#AppLongName}
DefaultDirName={pf32}\Oni
OutputBaseFilename={#AppShortName}-v{#AppVersion}-Setup
DefaultGroupName=Oni AE

DirExistsWarning=no
AppendDefaultDirName=no

ShowComponentSizes=no
AppPublisher=
AppPublisherURL=
AppSupportURL=
AppUpdatesURL=
AllowNoIcons=yes
OutputDir=.
Compression=lzma2/max
SolidCompression=yes

[Languages]
Name: "en"; MessagesFile: "compiler:Default.isl"

[Messages]
en.SelectDirBrowseLabel=Please select the installation directory of Oni.

[CustomMessages]
en.wrongDir=This doesn't seem to be your Oni installation; I don't see a file here named "Oni.exe".

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Components]
Name: "JRE"; Description: "JRE"
Name: "AEI"; Description: "AEI"

[Dirs]
Name: "{app}\Edition"; Permissions: users-modify
 
[Files]
Source: "AEInstaller2.jar"; DestDir: "{app}\Edition\AEInstaller"; Components: AEI
Source: "JRE\*"; DestDir: "{app}\Edition\AEInstaller\JRE"; Excludes: ".svn"; Flags: createallsubdirs recursesubdirs onlyifdoesntexist; Components: JRE
Source: "AElogo.ico"; DestDir: "{app}\Edition\AEInstaller"; Components: AEI

[Icons]
Name: "{group}\AEInstaller 2"; Filename: "{app}\Edition\AEInstaller\JRE\bin\javaw.exe"; WorkingDir: "{app}\Edition\AEInstaller"; IconFilename: "{app}\Edition\AEInstaller\AElogo.ico"; Parameters: "-Dsun.java2d.d3d=false -jar AEInstaller2.jar"; Check: not IsJavaInstalled
Name: "{commondesktop}\AEInstaller 2"; Filename: "{app}\Edition\AEInstaller\JRE\bin\javaw.exe"; WorkingDir: "{app}\Edition\AEInstaller"; IconFilename: "{app}\Edition\AEInstaller\AElogo.ico"; Parameters: "-Dsun.java2d.d3d=false -jar AEInstaller2.jar"; Tasks: desktopicon; Check: not IsJavaInstalled
Name: "{group}\AEInstaller 2"; Filename: "{code:GetJavaPath}\bin\javaw.exe"; WorkingDir: "{app}\Edition\AEInstaller"; IconFilename: "{app}\Edition\AEInstaller\AElogo.ico"; Parameters: "-Dsun.java2d.d3d=false -jar AEInstaller2.jar"; Check: IsJavaInstalled
Name: "{commondesktop}\AEInstaller 2"; Filename: "{code:GetJavaPath}\bin\javaw.exe"; WorkingDir: "{app}\Edition\AEInstaller"; IconFilename: "{app}\Edition\AEInstaller\AElogo.ico"; Parameters: "-Dsun.java2d.d3d=false -jar AEInstaller2.jar"; Tasks: desktopicon; Check: IsJavaInstalled


[Code]
var
  javaPath: String;

procedure DecodeVersion (verstr: String; var verint: array of Integer);
var
  i,p: Integer; s: string;
begin
  // initialize array
  verint := [0,0,0,0];
  i := 0;
  while ((Length(verstr) > 0) and (i < 4)) do
  begin
    p := pos ('.', verstr);
    if p > 0 then
    begin
      if p = 1 then s:= '0' else s:= Copy (verstr, 1, p - 1);
      verint[i] := StrToInt(s);
      i := i + 1;
      verstr := Copy (verstr, p+1, Length(verstr));
    end
    else
    begin
      verint[i] := StrToInt (verstr);
      verstr := '';
    end;
  end;

end;

function CompareVersion (ver1, ver2: String) : Integer;
var
  verint1, verint2: array of Integer;
  i: integer;
begin
  SetArrayLength (verint1, 4);
  DecodeVersion (ver1, verint1);

  SetArrayLength (verint2, 4);
  DecodeVersion (ver2, verint2);

  Result := 0; i := 0;
  while ((Result = 0) and ( i < 4 )) do
  begin
    if verint1[i] > verint2[i] then
      Result := 1
    else
      if verint1[i] < verint2[i] then
        Result := -1;
    i := i + 1;
  end;

end;

procedure CheckJavaRuntime();
var
  Res: Boolean;
  JavaVer: String;
begin
  Res := RegQueryStringValue(HKLM, 'SOFTWARE\JavaSoft\Java Runtime Environment', 'CurrentVersion', JavaVer);
  if Res = True then
  begin
    if Length( JavaVer ) > 0 then
    begin
    	if CompareVersion(JavaVer, '{#MinJavaVersion}') >= 0 then
    	begin
        Res := RegQueryStringValue(HKLM, 'SOFTWARE\JavaSoft\Java Runtime Environment\'+JavaVer, 'JavaHome', javaPath);
    	end;
    end;
  end;
end;

function IsJavaInstalled(): Boolean;
begin
  Result := Length(javaPath) > 0;
end;

function GetJavaPath(Param: String): String;
begin
  Result := javaPath;
end;

function InitializeSetup(): Boolean;
begin
  CheckJavaRuntime();
  Result := True;
end;

procedure InitializeWizard();
var
  Components : TNewCheckListbox;
  i : integer;
begin
      Components := WizardForm.ComponentsList;
      i := Components.Items.IndexOf('JRE');
      if i <> -1 then
      begin
        Components.ItemEnabled[i] := false;
        Components.Checked[i] := not IsJavaInstalled();
      end;
      i := Components.Items.IndexOf('AEI');
      if i <> -1 then
      begin
        Components.ItemEnabled[i] := false;
        Components.Checked[i] := true;
      end;
end;

function DirOk(Path: String): boolean;
begin
  Result := DirExists(Path+'\GameDataFolder') and FileExists(Path+'\Oni.exe');
end;

function NextButtonClick(CurPageID: Integer): boolean;
begin
  Result := True;

  if CurPageID = wpSelectDir then
  begin
    if (not DirOk(WizardDirValue)) then
    begin
      MsgBox(CustomMessage('wrongDir'), mbError, MB_OK);
      Result := False;
    end;
  end;
end;


function ShouldSkipPage(PageID: Integer): Boolean;
begin
  Result := PageID = wpSelectComponents;
end;

function UpdateReadyMemo(Space, NewLine, MemoUserInfoInfo, MemoDirInfo, MemoTypeInfo, MemoComponentsInfo, MemoGroupInfo, MemoTasksInfo: String): String;
begin
  Result := MemoUserInfoInfo + NewLine;
  Result := Result + MemoDirInfo + NewLine;
  Result := Result + MemoGroupInfo + NewLine;
  Result := Result + MemoTasksInfo + NewLine;
end;

