package net.oni2.aeinstaller;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ResourceBundle;

import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;

import net.oni2.aeinstaller.backend.Paths;
import net.oni2.aeinstaller.backend.Settings;
import net.oni2.aeinstaller.backend.Settings.Platform;
import net.oni2.aeinstaller.backend.SizeFormatter;
import net.oni2.aeinstaller.backend.depot.DepotManager;
import net.oni2.aeinstaller.backend.oni.Installer;
import net.oni2.aeinstaller.backend.oni.OniSplit;
import net.oni2.aeinstaller.gui.HTMLLinkLabel;
import net.oni2.aeinstaller.gui.MainWin;

import org.javabuilders.swing.SwingJavaBuilder;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.DefaultApplication;

/**
 * @author Christian Illy
 */
public class AEInstaller2 {

	private static ResourceBundle imagesBundle = ResourceBundle
			.getBundle(AEInstaller2.class.getPackage().getName() + ".Images");
	private static ResourceBundle basicBundle = ResourceBundle
			.getBundle(AEInstaller2.class.getPackage().getName()
					+ ".AEInstaller");

	private static Application app = null;

	private static void initMacOS() {
		System.setProperty("apple.laf.useScreenMenuBar", "true");
		System.setProperty("com.apple.mrj.application.apple.menu.about.name",
				basicBundle.getString("appname"));
		app = new DefaultApplication();

		URL icon = AEInstaller2.class.getResource("images/AElogo.png");
		try {
			BufferedImage img = ImageIO.read(icon);
			app.setApplicationIconImage(img);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * @param args
	 *            Command line arguments
	 */
	public static void main(String[] args) {
		Paths.getPrefsPath().mkdirs();
		Paths.getDownloadPath().mkdirs();

		boolean debug = false;
		for (String a : args)
			if (a.equalsIgnoreCase("-debug"))
				debug = true;
		if (!debug) {
			try {
				System.setOut(new PrintStream(new File(Paths.getPrefsPath(),
						"aei_output.log")));
				System.setErr(new PrintStream(new File(Paths.getPrefsPath(),
						"aei_error.log")));
			} catch (FileNotFoundException e1) {
				e1.printStackTrace();
			}
		}

		if (Settings.getPlatform() == Platform.MACOS)
			initMacOS();

		Settings.deserializeFromFile();
		Settings.setDebug(debug);
		DepotManager.getInstance().loadFromFile(
				Settings.getDepotCacheFilename());

		SwingJavaBuilder.getConfig().addResourceBundle(imagesBundle);
		SwingJavaBuilder.getConfig().addResourceBundle(basicBundle);
		SwingJavaBuilder.getConfig().setMarkInvalidResourceBundleKeys(true);
		SwingJavaBuilder.getConfig().addType("JToolBarSeparator",
				JToolBar.Separator.class);

		System.setProperty("networkaddress.cache.ttl", "5");
		System.setProperty("networkaddress.cache.negative.ttl", "1");

		try {
			String laf = Settings.getInstance().get("lookandfeel",
					(String) null);
			if (laf == null) {
				if (Settings.getPlatform() == Platform.MACOS) {
					laf = UIManager.getSystemLookAndFeelClassName();
				} else {
					for (LookAndFeelInfo lafInfo : UIManager
							.getInstalledLookAndFeels()) {
						if (lafInfo.getName().equals("Nimbus"))
							laf = lafInfo.getClassName();
					}
				}
			}
			if (laf == null)
				laf = UIManager.getSystemLookAndFeelClassName();
			UIManager.setLookAndFeel(laf);
		} catch (Exception e) {
			e.printStackTrace();
		}
		JFrame.setDefaultLookAndFeelDecorated(true);

		// TODO: Remove debug output
		System.out.println("JarPath:   " + Paths.getInstallerPath());
		System.out.println("PrefsPath: " + Paths.getPrefsPath());
		System.out.println("DataPath:  " + Paths.getModsPath());
		System.out.println("DownPath:  " + Paths.getDownloadPath());
		System.out.println("TempPath:  " + Paths.getTempPath());
		System.out.println("ValidPath: " + Installer.verifyRunningDirectory());
		System.out.println("Platform:  " + Settings.getPlatform());
		System.out.println("Architect: " + Settings.getArchitecture());
		System.out.println(".NET:      " + OniSplit.isDotNETInstalled());
		System.out.println("OniSplit:  " + OniSplit.isOniSplitInstalled());
		System.out.println("Globalized:" + Installer.isEditionInitialized());

		// TODO: Check available space
		System.out
				.println("Free space on temp: "
						+ SizeFormatter.format(Paths.getTempPath()
								.getUsableSpace(), 3));
		System.out.println("Free space on Jar:  "
				+ SizeFormatter.format(Paths.getInstallerPath()
						.getUsableSpace(), 3));

		if (!OniSplit.isDotNETInstalled()) {
			HTMLLinkLabel hll = new HTMLLinkLabel();
			String dlUrl = "";
			switch (Settings.getPlatform()) {
				case WIN:
					switch (Settings.getArchitecture()) {
						case X86:
							dlUrl = "http://download.microsoft.com/download/c/6/e/c6e88215-0178-4c6c-b5f3-158ff77b1f38/NetFx20SP2_x86.exe";
							break;
						case AMD64:
							dlUrl = "http://download.microsoft.com/download/c/6/e/c6e88215-0178-4c6c-b5f3-158ff77b1f38/NetFx20SP2_x64.exe";
							break;
					}
					break;
				default:
					dlUrl = "http://www.go-mono.com/mono-downloads/download.html";
			}
			hll.setText(basicBundle.getString("dotNetMissing.text").replaceAll(
					"%1", String.format("<a href=\"%s\">%s</a>", dlUrl, dlUrl)));
			JOptionPane.showMessageDialog(null, hll,
					basicBundle.getString("dotNetMissing.title"),
					JOptionPane.ERROR_MESSAGE);
			return;
		}

		if (!Installer.verifyRunningDirectory()) {
			JOptionPane.showMessageDialog(null,
					basicBundle.getString("invalidPath.text"),
					basicBundle.getString("invalidPath.title"),
					JOptionPane.ERROR_MESSAGE);
			if (!Settings.isDebug()) {
				return;
			}
		}

		boolean offline = !DepotManager.getInstance().checkConnection();
		if (offline) {
			JOptionPane.showMessageDialog(null,
					basicBundle.getString("offlineMode.text"),
					basicBundle.getString("offlineMode.title"),
					JOptionPane.INFORMATION_MESSAGE);
		}
		Settings.getInstance().setOfflineMode(offline);

		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {
					MainWin mw = new MainWin();
					if (app != null) {
						app.addAboutMenuItem();
						app.setEnabledAboutMenu(true);
						app.addPreferencesMenuItem();
						app.setEnabledPreferencesMenu(true);
						app.addApplicationListener(mw);
					}
					mw.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});

	}
}
