package net.oni2.aeinstaller.gui.toolmanager;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.TreeMap;

import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import net.oni2.aeinstaller.backend.SizeFormatter;
import net.oni2.aeinstaller.backend.mods.Mod;
import net.oni2.aeinstaller.backend.mods.ModManager;
import net.oni2.aeinstaller.backend.oni.Installer;
import net.oni2.aeinstaller.gui.HTMLLinkLabel;

import org.javabuilders.BuildResult;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class ToolManager extends JDialog implements ListSelectionListener {
	private static final long serialVersionUID = 343221630538866384L;

	private ResourceBundle bundle = ResourceBundle.getBundle(getClass()
			.getName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private JList lstTools;

	private JLabel lblSubmitterVal;
	private JLabel lblCreatorVal;
	private JLabel lblPlatformVal;
	private JLabel lblPackageNumberVal;
	private HTMLLinkLabel lblDescriptionVal;
	private JLabel lblDownloadSizeVal;

	private JButton btnInstall;

	/**
	 * Open the dialog
	 */
	public ToolManager() {
		setMinimumSize(new Dimension(getWidth() + 100, getHeight() + 100));

		AbstractAction closeAction = new AbstractAction() {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		};
		KeyStroke ksCtrlW = KeyStroke
				.getKeyStroke('W', KeyEvent.CTRL_DOWN_MASK);
		getRootPane()
				.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
				.put(ksCtrlW, "close");
		getRootPane().getActionMap().put("close", closeAction);

		lstTools.addListSelectionListener(this);
		lstTools.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		DefaultListModel dlm = new DefaultListModel();
		TreeMap<String, Mod> tools = ModManager.getInstance().getTools();
		for (String name : tools.keySet())
			dlm.addElement(tools.get(name));
	}

	@SuppressWarnings("unused")
	private void install() {
		// TODO: care for offline mode
		JOptionPane.showMessageDialog(this, "install", "todo",
				JOptionPane.INFORMATION_MESSAGE);
	}

	@SuppressWarnings("unused")
	private void installDone() {
	}

	@Override
	public void valueChanged(ListSelectionEvent evt) {
		lblSubmitterVal.setText("");
		lblCreatorVal.setText("");
		lblDescriptionVal.setText("");
		lblPlatformVal.setText("");
		lblPackageNumberVal.setText("");
		lblDownloadSizeVal.setText("");
		btnInstall.setEnabled(false);

		if (lstTools.getSelectedValue() instanceof Mod) {
			Mod m = (Mod) lstTools.getSelectedValue();
			lblSubmitterVal.setText(m.getName());
			lblCreatorVal.setText(m.getCreator());
			lblDescriptionVal.setText(m.getDescription());
			lblPlatformVal.setText(m.getPlatform().toString());
			lblPackageNumberVal.setText(m.getPackageNumberString());
			lblDownloadSizeVal.setText(SizeFormatter.format(m.getZipSize(), 3));
			btnInstall.setEnabled(true);
			if (Installer.getInstalledTools().contains(m.getPackageNumber())) {
				btnInstall.setText(bundle.getString("btnInstall.un.text"));
				btnInstall.setToolTipText(bundle
						.getString("btnInstall.un.tooltip"));
			} else {
				btnInstall.setText(bundle.getString("btnInstall.text"));
				btnInstall.setToolTipText(bundle
						.getString("btnInstall.tooltip"));
			}
		}
	}
}
