package net.oni2.aeinstaller.backend.network;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * @author Christian Illy
 */
public class DrupalJSONQuery {

	/**
	 * Get the JSON array found at the given url
	 * 
	 * @param url
	 *            URL to look at for the JSON data
	 * @return JSON array of data
	 * @throws Exception
	 *             On HTTP status code <200 / >299
	 */
	public static JSONArray executeQuery(String url) throws Exception {
		BufferedReader input = null;
		HttpRequestBase httpQuery = null;

		try {
			DefaultHttpClient httpclient = new DefaultHttpClient();
			httpQuery = new HttpGet(url);

			HttpResponse response = httpclient.execute(httpQuery);

			int code = response.getStatusLine().getStatusCode();
			if ((code > 299) || (code < 200)) {
				throw new Exception(String.format(
						"Error fetching content (HTTP status code %d).", code));
			}

			HttpEntity entity = response.getEntity();

			input = new BufferedReader(new InputStreamReader(
					entity.getContent()));
			StringBuffer json = new StringBuffer();

			char data[] = new char[1024];
			int dataRead;
			while ((dataRead = input.read(data, 0, 1024)) != -1) {
				json.append(data, 0, dataRead);
			}

			EntityUtils.consume(entity);

			JSONArray jA = null;
			if (json.charAt(0) == '{') {
				jA = new JSONArray();
				jA.put(new JSONObject(json.toString()));
			} else
				jA = new JSONArray(json.toString());

			return jA;
		} catch (JSONException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (httpQuery != null)
				httpQuery.releaseConnection();
			if (input != null) {
				try {
					input.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return null;
	}
}
