package net.oni2.aeinstaller.gui.modtable;

import javax.swing.RowFilter;

import net.oni2.aeinstaller.backend.mods.Mod;
import net.oni2.aeinstaller.backend.mods.Type;

/**
 * @author Christian Illy
 */
public class ModTableFilter extends RowFilter<ModTableModel, Integer> {
	private Type type = null;
	private int downloadState = 0;

	/**
	 * @param type
	 *            Type of mods to show (null for all)
	 * @param downloadState
	 *            Show only: 0 = all, 1 = online, 2 = downloaded
	 */
	public ModTableFilter(Type type, int downloadState) {
		super();
		this.type = type;
		this.downloadState = downloadState;
	}

	@Override
	public boolean include(
			RowFilter.Entry<? extends ModTableModel, ? extends Integer> entry) {
		Mod mod = (Mod) entry.getModel().getValueAt(entry.getIdentifier(), -1);
		
		if (mod.isMandatoryMod())
			return false;

		if (!mod.isValidOnPlatform())
			return false;

		boolean result = true;
		if (type != null)
			result &= mod.getTypes().contains(type);
		switch (downloadState) {
			case 1:
				result &= !mod.isLocalAvailable();
				break;
			case 2:
				result &= mod.isLocalAvailable();
				break;
		}
		
		return result;
	}
}
