package net.oni2.aeinstaller.gui.toolmanager;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.TreeSet;

import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import net.oni2.aeinstaller.backend.Settings;
import net.oni2.aeinstaller.backend.SizeFormatter;
import net.oni2.aeinstaller.backend.mods.Mod;
import net.oni2.aeinstaller.backend.mods.ModManager;
import net.oni2.aeinstaller.backend.oni.Installer;
import net.oni2.aeinstaller.gui.HTMLLinkLabel;
import net.oni2.aeinstaller.gui.downloadwindow.Downloader;

import org.javabuilders.BuildResult;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class ToolManager extends JDialog implements ListSelectionListener {
	private static final long serialVersionUID = 343221630538866384L;

	private ResourceBundle bundle = ResourceBundle
			.getBundle("net.oni2.aeinstaller.localization."
					+ getClass().getSimpleName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private JSplitPane contents;

	private JList lstTools;

	private JLabel lblTitleVal;
	private JLabel lblSubmitterVal;
	private JLabel lblCreatorVal;
	private JLabel lblPlatformVal;
	private JLabel lblPackageNumberVal;
	private HTMLLinkLabel lblDescriptionVal;
	private JLabel lblDownloadSizeVal;

	private JButton btnInstall;

	private Icon icoInstall = null;
	private Icon icoUninstall = null;

	/**
	 * Open the dialog
	 */
	public ToolManager() {
		setMinimumSize(new Dimension(getWidth() + 100, getHeight() + 100));

		AbstractAction closeAction = new AbstractAction() {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		};
		KeyStroke ksCtrlW = KeyStroke
				.getKeyStroke('W', KeyEvent.CTRL_DOWN_MASK);
		getRootPane()
				.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
				.put(ksCtrlW, "close");
		getRootPane().getActionMap().put("close", closeAction);

		contents.setDividerLocation(200);
		contents.setResizeWeight(0.4);

		lstTools.addListSelectionListener(this);
		lstTools.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		DefaultListModel dlm = new DefaultListModel();
		TreeMap<String, Mod> tools = ModManager.getInstance().getTools();
		for (String name : tools.keySet())
			dlm.addElement(tools.get(name));
		lstTools.setModel(dlm);

		icoInstall = new ImageIcon(getClass().getResource(
				SwingJavaBuilder.getConfig().getResource("img.install")));
		icoUninstall = new ImageIcon(getClass().getResource(
				SwingJavaBuilder.getConfig().getResource("img.uninstall")));
	}

	@SuppressWarnings("unused")
	private void install() {
		Object o = lstTools.getSelectedValue();
		if (o instanceof Mod) {
			Mod theMod = (Mod) o;

			if (theMod.isInstalled()) {
				TreeSet<Mod> tools = new TreeSet<Mod>();
				tools.add(theMod);
				Installer.uninstallTools(tools);
			} else {
				if (!theMod.isLocalAvailable()) {
					if (Settings.getInstance().isOfflineMode()) {
						JOptionPane.showMessageDialog(this,
								bundle.getString("offlineMode.text"),
								bundle.getString("offlineMode.title"),
								JOptionPane.WARNING_MESSAGE);
						return;
					}

					TreeSet<Mod> toDownload = new TreeSet<Mod>();
					toDownload.add(theMod);

					Downloader dl = new Downloader(toDownload);
					try {
						dl.setVisible(true);
						if (!dl.isFinished())
							return;
					} finally {
						dl.dispose();
					}
				}

				TreeSet<Mod> tools = new TreeSet<Mod>();
				tools.add(theMod);
				Installer.installTools(tools);
			}
		}
		valueChanged(null);
	}

	@Override
	public void valueChanged(ListSelectionEvent evt) {
		lblTitleVal.setText("");
		lblSubmitterVal.setText("");
		lblCreatorVal.setText("");
		lblDescriptionVal.setText("");
		lblPlatformVal.setText("");
		lblPackageNumberVal.setText("");
		lblDownloadSizeVal.setText("");
		btnInstall.setEnabled(false);
		btnInstall.setIcon(icoInstall);

		if (lstTools.getSelectedValue() instanceof Mod) {
			Mod m = (Mod) lstTools.getSelectedValue();
			lblTitleVal.setText(m.getName());
			lblSubmitterVal.setText(m.getSubmitter());
			lblCreatorVal.setText(m.getCreator());
			lblDescriptionVal.setText(m.getDescription());
			lblPlatformVal.setText(m.getPlatform().toString());
			lblPackageNumberVal.setText(m.getPackageNumberString());
			lblDownloadSizeVal.setText(SizeFormatter.format(m.getZipSize(), 3));
			btnInstall.setEnabled(true);
			if (m.isInstalled()) {
				btnInstall.setText(bundle.getString("btnInstall.un.text"));
				btnInstall.setToolTipText(bundle
						.getString("btnInstall.un.tooltip"));
				btnInstall.setIcon(icoUninstall);
			} else {
				btnInstall.setText(bundle.getString("btnInstall.text"));
				btnInstall.setToolTipText(bundle
						.getString("btnInstall.tooltip"));
			}
		}
	}
}
