package net.oni2.aeinstaller.backend.mods.download;

import net.oni2.aeinstaller.backend.mods.Mod;
import net.oni2.aeinstaller.backend.mods.download.ModDownloader.State;

/**
 * @author Christian Illy
 */
public interface ModDownloaderListener {
	/**
	 * Callback for progress updates on mod downloads
	 * 
	 * @param source
	 *            Event source
	 * @param currentDownload
	 *            Currently downloading mod
	 * @param state
	 *            Current state
	 * @param filesDown
	 *            Downloaded(+unpacked) files
	 * @param filesTotal
	 *            Files in total to handle
	 * @param bytesDown
	 *            Bytes downloaded
	 * @param bytesTotal
	 *            Bytes in total to handle
	 * @param duration
	 *            Duration of downloads in seconds
	 * @param remaining
	 *            Remaining time in seconds
	 * @param speed
	 *            Average download speed in B/s
	 */
	public void updateStatus(ModDownloader source, Mod currentDownload,
			State state, int filesDown, int filesTotal, int bytesDown,
			int bytesTotal, int duration, int remaining, int speed);
}
