package net.oni2.aeinstaller.backend.packages.download;

import net.oni2.aeinstaller.backend.packages.Package;
import net.oni2.aeinstaller.backend.packages.download.ModDownloader.State;

/**
 * @author Christian Illy
 */
public interface ModDownloaderListener {
	/**
	 * Callback for progress updates on mod downloads
	 * 
	 * @param source
	 *            Event source
	 * @param currentDownload
	 *            Currently downloading mod
	 * @param state
	 *            Current state
	 * @param filesDown
	 *            Downloaded(+unpacked) files
	 * @param filesTotal
	 *            Files in total to handle
	 * @param bytesDown
	 *            Bytes downloaded
	 * @param bytesTotal
	 *            Bytes in total to handle
	 * @param duration
	 *            Duration of downloads in seconds
	 * @param remaining
	 *            Remaining time in seconds
	 * @param speed
	 *            Average download speed in B/s
	 */
	public void updateStatus(ModDownloader source, Package currentDownload,
			State state, int filesDown, int filesTotal, int bytesDown,
			int bytesTotal, int duration, int remaining, int speed);
}
