package net.oni2.aeinstaller.gui.corepackages;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.TreeSet;

import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import net.oni2.aeinstaller.backend.SizeFormatter;
import net.oni2.aeinstaller.backend.packages.Package;
import net.oni2.aeinstaller.backend.packages.PackageManager;
import net.oni2.aeinstaller.backend.packages.Type;
import net.oni2.aeinstaller.gui.HTMLLinkLabel;

import org.javabuilders.BuildResult;
import org.javabuilders.swing.SwingJavaBuilder;

/**
 * @author Christian Illy
 */
public class CorePackagesDialog extends JDialog implements
		ListSelectionListener {
	private static final long serialVersionUID = -5444213842599816301L;

	private ResourceBundle bundle = ResourceBundle
			.getBundle("net.oni2.aeinstaller.localization."
					+ getClass().getSimpleName());
	@SuppressWarnings("unused")
	private BuildResult result = SwingJavaBuilder.build(this, bundle);

	private JSplitPane contents;

	private JList lstTools;

	private JLabel lblTitleVal;
	private JLabel lblCreatorVal;
	private JLabel lblTypesVal;
	private JLabel lblPlatformVal;
	private JLabel lblPackageNumberVal;
	private JLabel lblVersionNumberVal;
	private JLabel lblLastChangeVal;
	private HTMLLinkLabel lblDescriptionVal;
	private JLabel lblDownloadSizeVal;

	private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

	/**
	 * Open the dialog
	 */
	public CorePackagesDialog() {
		setMinimumSize(new Dimension(getWidth() + 100, getHeight() + 100));

		AbstractAction closeAction = new AbstractAction() {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent arg0) {
				dispose();
			}
		};
		KeyStroke ksCtrlW = KeyStroke
				.getKeyStroke('W', KeyEvent.CTRL_DOWN_MASK);
		getRootPane()
				.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
				.put(ksCtrlW, "close");
		getRootPane().getActionMap().put("close", closeAction);

		contents.setDividerLocation(200);
		contents.setResizeWeight(0.4);

		lstTools.addListSelectionListener(this);
		lstTools.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

		DefaultListModel dlm = new DefaultListModel();
		TreeSet<Package> tools = PackageManager.getInstance().getCoreTools();
		for (Package m : tools)
			dlm.addElement(m);
		TreeSet<Package> mods = PackageManager.getInstance().getCoreMods();
		for (Package m : mods)
			dlm.addElement(m);
		lstTools.setModel(dlm);

		setLocationRelativeTo(null);
		lblDescriptionVal.setMargin(new Insets(-15, 0, 0, 0));
	}

	@Override
	public void valueChanged(ListSelectionEvent evt) {
		lblTitleVal.setText("");
		lblCreatorVal.setText("");
		lblDescriptionVal.setText("");
		lblTypesVal.setText("");
		lblPlatformVal.setText("");
		lblPackageNumberVal.setText("");
		lblVersionNumberVal.setText("");
		lblLastChangeVal.setText("");
		lblDownloadSizeVal.setText("");

		if (lstTools.getSelectedValue() instanceof Package) {
			Package m = (Package) lstTools.getSelectedValue();
			lblTitleVal.setText(m.getName());
			lblCreatorVal.setText(m.getCreator());
			lblDescriptionVal.setText(m.getDescription());

			String types = "";
			for (Type t : m.getTypes()) {
				if (types.length() > 0)
					types += ", ";
				types += t.getName();
			}
			lblTypesVal.setText(types);
			lblPlatformVal.setText(m.getPlatform().toString());
			lblPackageNumberVal.setText(m.getPackageNumberString());
			lblVersionNumberVal.setText(m.getVersion());
			if (m.getFile() != null)
				lblLastChangeVal.setText(sdf.format(new Date(m.getFile()
						.getTimestamp() * 1000)));
			lblDownloadSizeVal.setText(SizeFormatter.format(m.getZipSize(), 3));
		}
	}
}
