package net.oni2.aeinstaller.gui.modtable;

import javax.swing.RowFilter;

import net.oni2.aeinstaller.backend.packages.Package;
import net.oni2.aeinstaller.backend.packages.Type;

/**
 * @author Christian Illy
 */
public class ModTableFilter extends RowFilter<ModTableModel, Integer> {
	private Type type = null;
	private int downloadState = 0;

	private boolean showCorePackages = false;
	private boolean showInvalidPlatform = false;

	/**
	 * @param type
	 *            Type of mods to show (null for all)
	 * @param downloadState
	 *            Show only: 0 = all, 1 = online, 2 = downloaded
	 * @param showCorePackages
	 *            Show core packages in table
	 * @param showInvalidPlatform
	 *            Show packages not valid on this platform
	 */
	public ModTableFilter(Type type, int downloadState,
			boolean showCorePackages, boolean showInvalidPlatform) {
		super();
		this.type = type;
		this.downloadState = downloadState;
		this.showCorePackages = showCorePackages;
		this.showInvalidPlatform = showInvalidPlatform;
	}

	@Override
	public boolean include(
			RowFilter.Entry<? extends ModTableModel, ? extends Integer> entry) {
		Package mod = (Package) entry.getModel().getValueAt(
				entry.getIdentifier(), -1);

		if (mod.isCorePackage() && !showCorePackages)
			return false;

		if (!mod.isValidOnPlatform() && !showInvalidPlatform)
			return false;

		boolean result = true;
		if (type != null)
			result &= mod.getTypes().contains(type);
		switch (downloadState) {
			case 1:
				result &= !mod.isLocalAvailable();
				break;
			case 2:
				result &= mod.isLocalAvailable();
				break;
		}

		return result;
	}
}
