package net.oni2.aeinstaller.backend;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;

/**
 * @author Christian Illy
 */
public class ImageResizer {
	/**
	 * @param src
	 *            Source image
	 * @param width
	 *            New width
	 * @param height
	 *            New height
	 * @return Resized image icon
	 */
	public static ImageIcon resizeImage(ImageIcon src, int width, int height) {
		Image img = src.getImage();
		BufferedImage bi = new BufferedImage(img.getWidth(null),
				img.getHeight(null), BufferedImage.TYPE_INT_ARGB);
		Graphics g = bi.createGraphics();
		g.drawImage(img, 0, 0, width, height, null);
		return new ImageIcon(bi);
	}
}
