package net.oni2.aeinstaller.backend;

import java.io.File;
import java.util.Vector;

import net.oni2.aeinstaller.backend.Settings.Platform;
import net.oni2.aeinstaller.backend.packages.Package;

/**
 * @author Christian Illy
 */
public class ToolLauncher {
	/**
	 * @param p
	 *            Package of tool to launch
	 * @throws Exception
	 *             If a required runtime is not found
	 */
	public static void launch(Package p) throws Exception {
		File exe = p.getExeFile();

		Vector<String> params = new Vector<String>();
		switch (p.getExeType()) {
			case OSBINARY:
				break;
			case DOTNET:
				if (!DotNet.isInstalled())
					throw new Exception(".NET not found");
				if (Settings.getPlatform() != Platform.WIN) {
					params.add(DotNet.getRuntimeExe());
				}
				break;
			case JAR:
				File jre = null;
				if (Settings.getPlatform() == Platform.WIN)
					jre = new File(System.getProperties().getProperty(
							"java.home"), "bin/javaw.exe");
				else
					jre = new File(System.getProperties().getProperty(
							"java.home"), "bin/java");
				if (!jre.exists())
					throw new Exception("JRE not found");
				params.add(jre.getPath());
				params.add("-jar");
				break;
		}
		params.add(exe.getPath());

		File wd = p.getWorkingDir();

		AppExecution.execute(params, wd);
	}
}
