package net.oni2.aeinstaller.backend;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Vector;

import net.oni2.aeinstaller.backend.Settings.Architecture;
import net.oni2.aeinstaller.backend.Settings.Platform;

/**
 * @author Christian Illy
 */
public class DotNet {

	/**
	 * @return is a .NET implementation installed?
	 */
	public static boolean isInstalled() {
		switch (Settings.getPlatform()) {
			case WIN:
				try {
					int view = WinRegistry.KEY_WOW64_32KEY;
					if (Settings.getArchitecture() == Architecture.AMD64)
						view = WinRegistry.KEY_WOW64_64KEY;

					Map<String, String> m = WinRegistry
							.readStringValues(
									WinRegistry.HKEY_LOCAL_MACHINE,
									"Software\\Microsoft\\NET Framework Setup\\NDP\\v2.0.50727",
									view);
					return m != null;
				} catch (IllegalArgumentException e) {
					e.printStackTrace();
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				} catch (InvocationTargetException e) {
					e.printStackTrace();
				} catch (Exception e) {
					if (!e.getMessage()
							.equals("Registry access not supported (not a Windows OS?)."))
						e.printStackTrace();
				}
				return false;
			case MACOS:
			case LINUX:
				Vector<String> cmd = new Vector<String>();
				cmd.add("which");
				cmd.add("mono");
				Vector<String> res = null;
				try {
					res = AppExecution.executeAndWait(cmd);
				} catch (IOException e) {
					e.printStackTrace();
				}
				if (res != null) {
					if (res.get(0).startsWith("/")
							&& res.get(0).endsWith("mono")) {
						return true;
					}
				}
				return false;
			default:
				return false;
		}
	}

	/**
	 * @return Get the .Net runtime executable name
	 */
	public static String getRuntimeExe() {
		if (Settings.getPlatform() != Platform.WIN)
			return "mono";
		return "";
	}

}
