package net.oni2.aeinstaller.backend.oni;

import java.io.File;
import java.io.IOException;
import java.util.Vector;

import net.oni2.aeinstaller.backend.CaseInsensitiveFile;
import net.oni2.aeinstaller.backend.DotNet;
import net.oni2.aeinstaller.backend.Paths;
import net.oni2.aeinstaller.backend.appexecution.AppExecution;
import net.oni2.aeinstaller.backend.appexecution.AppExecutionResult;

/**
 * @author Christian Illy
 */
public class XMLTools {

	/**
	 * Patch the given XML file with the given patch
	 * 
	 * @param patch
	 *            Patchfile
	 * @param source
	 *            File to patch
	 * 
	 * @return XMLTools output
	 */
	public static AppExecutionResult patch(File patch, File source) {
		Vector<String> cmdLine = getProgramInvocation();
		// xmlTools.exe patchfile -filename:PATCH -forceinfiles:TOPATCH
		cmdLine.add("patchfile");
		cmdLine.add("-filename:" + patch.getPath());
		cmdLine.add("-forceinfiles:" + source.getPath());
		AppExecutionResult res = null;
		try {
			res = AppExecution.executeAndWait(cmdLine);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return res;
	}

	private static Vector<String> getProgramInvocation() {
		Vector<String> res = new Vector<String>();
		if (DotNet.getRuntimeExe().length() > 0)
			res.add(DotNet.getRuntimeExe());
		res.add(getProgramFile().getPath());
		return res;
	}

	private static File getProgramFile() {
		File toolsPath = CaseInsensitiveFile.getCaseInsensitiveFile(Paths.getEditionBasePath(), "Tools");
		return CaseInsensitiveFile.getCaseInsensitiveFile(toolsPath, "xmlTools.exe");
	}
}
