package net.oni2.aeinstaller.backend.appexecution;

import java.util.Vector;

/**
 * @author Christian Illy
 */
public class AppExecutionResult {
	/**
	 * Returned error code
	 */
	public int errorCode;
	/**
	 * Call command line
	 */
	public Vector<String> cmdLine;
	/**
	 * Combined StdOut+ErrOut lines
	 */
	public Vector<String> output;
	/**
	 * Time the app was run for
	 */
	public int time;

	/**
	 * @param errorCode
	 *            Error code from executed program
	 * @param cmdLine
	 *            Commandline of call
	 * @param output
	 *            Output of executed program
	 * @param time
	 *            Time of execution in ms
	 */
	public AppExecutionResult(int errorCode, Vector<String> cmdLine,
			Vector<String> output, int time) {
		this.errorCode = errorCode;
		this.cmdLine = cmdLine;
		this.output = output;
		this.time = time;
	}
}