package net.oni2.aeinstaller.backend.appexecution;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import java.util.Vector;

/**
 * @author Christian Illy
 */
public class AppExecution {
	/**
	 * Execute a short running application and wait for termination
	 * 
	 * @param cmdLine
	 *            List of command and arguments
	 * @return Error code and list of output lines
	 * @throws IOException
	 *             Exc
	 */
	public static AppExecutionResult executeAndWait(Vector<String> cmdLine)
			throws IOException {
		long start = new Date().getTime();
		ProcessBuilder pb = new ProcessBuilder(cmdLine);
		pb.redirectErrorStream(true);
		Process proc = pb.start();

		InputStream is = proc.getInputStream();
		InputStreamReader isr = new InputStreamReader(is);
		BufferedReader br = new BufferedReader(isr);

		String line;
		Vector<String> lines = new Vector<String>();

		while ((line = br.readLine()) != null) {
			lines.add(line);
		}
		try {
			proc.waitFor();
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return new AppExecutionResult(proc.exitValue(), cmdLine, lines,
				(int) (new Date().getTime() - start));
	}

	/**
	 * Execute an app without waiting
	 * 
	 * @param cmd
	 *            Command and parameters
	 * @param workingDirectory
	 *            Working directory of app
	 */
	public static void execute(List<String> cmd, File workingDirectory) {
		try {
			ProcessBuilder pb = new ProcessBuilder(cmd);
			pb.directory(workingDirectory);
			pb.start();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
